/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.ws;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ws.AbstractBasicTest;
import com.ning.http.client.ws.EchoTextWebSocketServlet;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class RedirectTest
extends AbstractBasicTest {
    protected int port2;

    @Override
    @BeforeClass
    public void setUpGlobal() throws Exception {
        this.port1 = this.findFreePort();
        this._connector = new ServerConnector(this.getServer());
        this._connector.setPort(this.port1);
        this.addConnector((Connector)this._connector);
        this.port2 = this.findFreePort();
        ServerConnector connector2 = new ServerConnector(this.getServer());
        connector2.setPort(this.port2);
        this.addConnector((Connector)connector2);
        WebSocketServlet _wsHandler = this.getWebSocketHandler();
        HandlerList list = new HandlerList();
        list.addHandler((Handler)new HandlerWrapper(){

            public void handle(String s, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
                if (request.getLocalPort() == RedirectTest.this.port2) {
                    httpServletResponse.sendRedirect(RedirectTest.this.getTargetUrl());
                }
            }
        });
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        ServletHolder echo = new ServletHolder((Servlet)_wsHandler);
        context.addServlet(echo, "/*");
        list.addHandler((Handler)context);
        this.setHandler((Handler)list);
        this.start();
        this.log.info("Local HTTP server started successfully");
    }

    @Override
    public WebSocketServlet getWebSocketHandler() {
        return new EchoTextWebSocketServlet();
    }

    @Test(timeOut=60000L)
    public void testRedirectToWSResource() throws Exception {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build());){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)client.prepareGet(this.getRedirectURL()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                    text.set("OnOpen");
                    latch.countDown();
                }

                public void onClose(WebSocket websocket) {
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnOpen");
            websocket.close();
        }
    }

    private String getRedirectURL() {
        return String.format("ws://127.0.0.1:%d/", this.port2);
    }
}

