/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.ws;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ws.TextMessageTest;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketCloseCodeReasonListener;
import com.ning.http.client.ws.WebSocketListener;
import com.ning.http.client.ws.WebSocketTextListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class CloseCodeReasonMessageTest
extends TextMessageTest {
    @Test(timeOut=60000L)
    public void onCloseWithCode() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new Listener(latch, text)).build()).get();
            websocket.close();
            latch.await();
            Assert.assertTrue((boolean)text.get().startsWith("1000"));
        }
    }

    @Test(timeOut=60000L)
    public void onCloseWithCodeServerClose() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<String> text = new AtomicReference<String>("");
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new Listener(latch, text)).build()).get();
            latch.await();
            String[] parts = text.get().split(" ");
            Assert.assertEquals((String)text.get(), (String)"1001-Idle Timeout");
        }
    }

    @Test(timeOut=60000L, expectedExceptions={ExecutionException.class})
    public void getWebSocketThrowsException() throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            client.prepareGet("http://apache.org").execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                }

                public void onError(Throwable t) {
                    latch.countDown();
                }
            }).build()).get();
        }
        latch.await();
    }

    @Test(timeOut=60000L, expectedExceptions={IllegalStateException.class, IllegalArgumentException.class})
    public void wrongStatusCode() throws Throwable {
        AsyncHttpClient client = this.getAsyncHttpClient(null);
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference throwable = new AtomicReference();
            client.prepareGet("http://apache.org").execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                }

                public void onError(Throwable t) {
                    throwable.set(t);
                    latch.countDown();
                }
            }).build());
            latch.await();
            Assert.assertNotNull(throwable.get());
            throw (Throwable)throwable.get();
        }
        catch (Throwable throwable) {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Test(timeOut=60000L, expectedExceptions={IllegalStateException.class, IllegalArgumentException.class})
    public void wrongProtocolCode() throws Throwable {
        AsyncHttpClient client = this.getAsyncHttpClient(null);
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference throwable = new AtomicReference();
            client.prepareGet("ws://www.google.com/").execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                }

                public void onError(Throwable t) {
                    throwable.set(t);
                    latch.countDown();
                }
            }).build());
            latch.await();
            Assert.assertNotNull(throwable.get());
            throw (Throwable)throwable.get();
        }
        catch (Throwable throwable) {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public static final class Listener
    implements WebSocketListener,
    WebSocketCloseCodeReasonListener {
        final CountDownLatch latch;
        final AtomicReference<String> text;

        public Listener(CountDownLatch latch, AtomicReference<String> text) {
            this.latch = latch;
            this.text = text;
        }

        public void onOpen(WebSocket websocket) {
        }

        public void onClose(WebSocket websocket) {
        }

        public void onClose(WebSocket websocket, int code, String reason) {
            this.text.set(code + "-" + reason);
            this.latch.countDown();
        }

        public void onError(Throwable t) {
            t.printStackTrace();
            this.latch.countDown();
        }
    }
}

