/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.uri;

import com.ning.http.client.uri.Uri;
import com.ning.http.client.uri.UriParser;
import java.net.MalformedURLException;
import java.net.URI;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UriTest {
    @Test
    private static void assertUriEquals(UriParser parser, URI uri) {
        Assert.assertEquals((String)parser.scheme, (String)uri.getScheme());
        Assert.assertEquals((String)parser.userInfo, (String)uri.getUserInfo());
        Assert.assertEquals((String)parser.host, (String)uri.getHost());
        Assert.assertEquals((int)parser.port, (int)uri.getPort());
        Assert.assertEquals((String)parser.path, (String)uri.getPath());
        Assert.assertEquals((String)parser.query, (String)uri.getQuery());
    }

    private static void validateAgainstAbsoluteURI(String url) throws MalformedURLException {
        UriParser parser = new UriParser();
        parser.parse(null, url);
        UriTest.assertUriEquals(parser, URI.create(url));
    }

    @Test
    public void testUrlWithPathAndQuery() throws MalformedURLException {
        UriTest.validateAgainstAbsoluteURI("http://example.com:8080/test?q=1");
    }

    @Test
    public void testUrlHasLeadingAndTrailingWhiteSpace() {
        UriParser parser = new UriParser();
        String url = "  http://user@example.com:8080/test?q=1  ";
        parser.parse(null, url);
        UriTest.assertUriEquals(parser, URI.create(url.trim()));
    }

    private static void validateAgainstRelativeURI(Uri uriContext, String urlContext, String url) {
        UriParser parser = new UriParser();
        parser.parse(uriContext, url);
        UriTest.assertUriEquals(parser, URI.create(urlContext).resolve(URI.create(url)));
    }

    @Test
    public void testResolveAbsoluteUriAgainstContext() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "");
        UriTest.validateAgainstRelativeURI(context, "https://example.com:80/path", "http://example.com/path");
    }

    @Test
    public void testFragmentTryingToTrickAuthorityAsBasicAuthCredentials() throws MalformedURLException {
        UriTest.validateAgainstAbsoluteURI("http://1.2.3.4:81#@5.6.7.8:82/aaa/b?q=xxx");
    }

    @Test
    public void testRootRelativePath() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2");
        UriTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "/relativeUrl");
    }

    @Test
    public void testCurrentDirRelativePath() {
        Uri context = new Uri("https", null, "example.com", 80, "/foo/bar", "q=2");
        UriTest.validateAgainstRelativeURI(context, "https://example.com:80/foo/bar?q=2", "relativeUrl");
    }

    @Test
    public void testFragmentOnly() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2");
        UriTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "#test");
    }

    @Test
    public void testRelativeUrlWithQuery() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2");
        UriTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "/relativePath?q=3");
    }

    @Test
    public void testRelativeUrlWithQueryOnly() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2");
        UriTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "?q=3");
    }

    @Test
    public void testRelativeURLWithDots() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2");
        UriTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "./relative/./url");
    }

    @Test
    public void testRelativeURLWithTwoEmbeddedDots() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2");
        UriTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "./relative/../url");
    }

    @Test
    public void testRelativeURLWithTwoTrailingDots() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2");
        UriTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "./relative/url/..");
    }

    @Test
    public void testRelativeURLWithOneTrailingDot() {
        Uri context = new Uri("https", null, "example.com", 80, "/path", "q=2");
        UriTest.validateAgainstRelativeURI(context, "https://example.com:80/path?q=2", "./relative/url/.");
    }

    @Test
    public void testSimpleParsing() {
        Uri url = Uri.create((String)"https://graph.facebook.com/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"graph.facebook.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/750198471659552/accounts/test-users");
        Assert.assertEquals((String)url.getQuery(), (String)"method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRootRelativeURIWithRootContext() {
        Uri context = Uri.create((String)"https://graph.facebook.com");
        Uri url = Uri.create((Uri)context, (String)"/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"graph.facebook.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/750198471659552/accounts/test-users");
        Assert.assertEquals((String)url.getQuery(), (String)"method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRootRelativeURIWithNonRootContext() {
        Uri context = Uri.create((String)"https://graph.facebook.com/foo/bar");
        Uri url = Uri.create((Uri)context, (String)"/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"graph.facebook.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/750198471659552/accounts/test-users");
        Assert.assertEquals((String)url.getQuery(), (String)"method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testNonRootRelativeURIWithNonRootContext() {
        Uri context = Uri.create((String)"https://graph.facebook.com/foo/bar");
        Uri url = Uri.create((Uri)context, (String)"750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"graph.facebook.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/foo/750198471659552/accounts/test-users");
        Assert.assertEquals((String)url.getQuery(), (String)"method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testAbsoluteURIWithContext() {
        Uri context = Uri.create((String)"https://hello.com/foo/bar");
        Uri url = Uri.create((Uri)context, (String)"https://graph.facebook.com/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"graph.facebook.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/750198471659552/accounts/test-users");
        Assert.assertEquals((String)url.getQuery(), (String)"method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRelativeUriWithDots() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2/");
        Uri url = Uri.create((Uri)context, (String)"../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/level1/other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithDotsAboveRoot() {
        Uri context = Uri.create((String)"https://hello.com/level1");
        Uri url = Uri.create((Uri)context, (String)"../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithAbsoluteDots() {
        Uri context = Uri.create((String)"https://hello.com/level1/");
        Uri url = Uri.create((Uri)context, (String)"/../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDots() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2/");
        Uri url = Uri.create((Uri)context, (String)"../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsAboveRoot() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2");
        Uri url = Uri.create((Uri)context, (String)"../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithAbsoluteConsecutiveDots() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2/");
        Uri url = Uri.create((Uri)context, (String)"/../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromRoot() {
        Uri context = Uri.create((String)"https://hello.com/");
        Uri url = Uri.create((Uri)context, (String)"../../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../../../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromRootResource() {
        Uri context = Uri.create((String)"https://hello.com/level1");
        Uri url = Uri.create((Uri)context, (String)"../../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../../../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromSubrootResource() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2");
        Uri url = Uri.create((Uri)context, (String)"../../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromLevel3Resource() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2/level3");
        Uri url = Uri.create((Uri)context, (String)"../../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }
}

