/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.NonBlockingInputStreamFeeder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.impl.FutureImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NonBlockingInputStreamFeederTest {
    private static final byte[] DATA = "Hello, world!".getBytes();
    private static final byte[] EMPTY = new byte[0];

    @Test
    public void feedSmallPayload() throws IOException {
        this.assertFeeding(DATA);
    }

    @Test
    public void feedEmptyPayload() throws IOException {
        this.assertFeeding(EMPTY);
    }

    @Test
    public void whenWriteQueuIsFullTheOnQueueWriteStrategyIsAppliedAndAllTheDataIsConsumed() throws IOException {
        byte[] data = DATA;
        int bufferSize = data.length / 2;
        FeedableBodyGenerator feedableBodyGenerator = new FeedableBodyGenerator();
        FeedableBodyGenerator spiedFeedableBodyGenerator = (FeedableBodyGenerator)Mockito.spy((Object)feedableBodyGenerator);
        NonBlockingInputStreamFeeder nonBlockingInputStreamFeeder = new NonBlockingInputStreamFeeder(spiedFeedableBodyGenerator, (InputStream)new ByteArrayInputStream(data), bufferSize);
        NonBlockingInputStreamFeeder spiedNonBlockingInputStreamFeeder = (NonBlockingInputStreamFeeder)Mockito.spy((Object)nonBlockingInputStreamFeeder);
        spiedFeedableBodyGenerator.setFeeder((FeedableBodyGenerator.Feeder)spiedNonBlockingInputStreamFeeder);
        FilterChainContext filterChainContext = (FilterChainContext)Mockito.mock(FilterChainContext.class);
        HttpRequestPacket requestPacket = (HttpRequestPacket)Mockito.mock(HttpRequestPacket.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)filterChainContext.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)connection.getMaxAsyncWriteQueueSize()).thenReturn((Object)100);
        Mockito.when((Object)spiedNonBlockingInputStreamFeeder.isReady()).thenReturn((Object)true).thenReturn((Object)false);
        spiedFeedableBodyGenerator.initializeAsynchronousTransfer(filterChainContext, requestPacket);
        ((NonBlockingInputStreamFeeder)Mockito.verify((Object)spiedNonBlockingInputStreamFeeder)).onFullWriteQueue(connection);
        ((Connection)Mockito.verify((Object)connection)).notifyCanWrite((WriteHandler)Mockito.any(WriteHandler.class));
        this.assertFeeding(DATA);
    }

    @Test
    public void whenExecutionExceptionIsThrownWhileQueueIsBlocking_thenDoNotWaitForQueueToBeFree() throws Exception {
        byte[] data = DATA;
        int bufferSize = data.length / 2;
        FeedableBodyGenerator feedableBodyGenerator = new FeedableBodyGenerator();
        FeedableBodyGenerator spiedFeedableBodyGenerator = (FeedableBodyGenerator)Mockito.spy((Object)feedableBodyGenerator);
        NonBlockingInputStreamFeeder nonBlockingInputStreamFeeder = new NonBlockingInputStreamFeeder(spiedFeedableBodyGenerator, (InputStream)new ByteArrayInputStream(data), bufferSize);
        NonBlockingInputStreamFeeder spiedNonBlockingInputStreamFeeder = (NonBlockingInputStreamFeeder)Mockito.spy((Object)nonBlockingInputStreamFeeder);
        spiedFeedableBodyGenerator.setFeeder((FeedableBodyGenerator.Feeder)spiedNonBlockingInputStreamFeeder);
        FilterChainContext filterChainContext = (FilterChainContext)Mockito.mock(FilterChainContext.class);
        HttpRequestPacket requestPacket = (HttpRequestPacket)Mockito.mock(HttpRequestPacket.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)filterChainContext.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)connection.getMaxAsyncWriteQueueSize()).thenReturn((Object)100);
        Transport transport = (Transport)Mockito.mock(Transport.class);
        Mockito.when((Object)connection.getTransport()).thenReturn((Object)transport);
        Mockito.when((Object)transport.getWriteTimeout((TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)1L);
        FutureImpl future = (FutureImpl)Mockito.mock(FutureImpl.class);
        Mockito.when((Object)((Boolean)future.get(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class))))).thenThrow(new Throwable[]{new ExecutionException(new IOException("Mocked exception"))});
        Mockito.when((Object)((Boolean)future.get())).thenThrow(new Throwable[]{new ExecutionException(new IOException("Mocked exception"))});
        spiedFeedableBodyGenerator.initializeAsynchronousTransfer(filterChainContext, requestPacket);
        ((NonBlockingInputStreamFeeder)Mockito.verify((Object)spiedNonBlockingInputStreamFeeder)).onFullWriteQueue(connection);
        ((Connection)Mockito.verify((Object)connection)).notifyCanWrite((WriteHandler)Mockito.any(WriteHandler.class));
        Assert.assertFalse((boolean)spiedNonBlockingInputStreamFeeder.onFullWriteQueue(connection));
    }

    private void assertFeeding(byte[] data) throws IOException {
        int bufferSize = data.length / 2;
        LinkedList buffers = new LinkedList();
        NonBlockingInputStreamFeeder nonBlockingInputStreamFeeder = new NonBlockingInputStreamFeeder(new FeedableBodyGenerator(), (InputStream)new ByteArrayInputStream(data), bufferSize);
        NonBlockingInputStreamFeeder mockedFeeder = (NonBlockingInputStreamFeeder)Mockito.spy((Object)nonBlockingInputStreamFeeder);
        ((NonBlockingInputStreamFeeder)Mockito.doAnswer(a -> {
            buffers.add((Buffer)a.getArgument(0));
            return null;
        }).when((Object)mockedFeeder)).feed((Buffer)Mockito.any(Buffer.class), Mockito.anyBoolean());
        while (mockedFeeder.isReady()) {
            mockedFeeder.canFeed();
        }
        byte[] received = buffers.stream().reduce(new byte[0], (acc, buff) -> NonBlockingInputStreamFeederTest.addAll(acc, Arrays.copyOfRange(buff.array(), buff.position(), buff.remaining())), (arr1, arr2) -> NonBlockingInputStreamFeederTest.addAll(arr1, arr2));
        Assert.assertEquals((byte[])received, (byte[])data);
    }

    private static byte[] addAll(byte[] one, byte[] two) {
        byte[] result = Arrays.copyOf(one, one.length + two.length);
        System.arraycopy(two, 0, result, one.length, two.length);
        return result;
    }
}

