/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.providers.grizzly.GrizzlyResponseHeaders;
import java.util.concurrent.CountDownLatch;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GrizzlyResponseHeadersTest {
    private static final int MIME_HEADERS_COUNT = 1000000;
    private static final String HEADER_PREFIX = "Header";

    @Test
    public void testNotRaceCondition() throws Exception {
        HttpResponsePacket response = (HttpResponsePacket)Mockito.mock(HttpResponsePacket.class);
        MimeHeaders headers = new MimeHeaders();
        headers.setMaxNumHeaders(1000000);
        for (int i = 0; i < 1000000; ++i) {
            headers.addValue(HEADER_PREFIX + i);
        }
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        ConcurrencyTestResult result1 = new ConcurrencyTestResult();
        ConcurrencyTestResult result2 = new ConcurrencyTestResult();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        GrizzlyResponseHeaders grizzlyHeaders = new GrizzlyResponseHeaders(response);
        Thread t1 = this.getThread(result1, latch1, grizzlyHeaders);
        Thread t2 = this.getThread(result2, latch2, grizzlyHeaders);
        t1.start();
        Thread.sleep(100L);
        t2.start();
        latch1.await();
        latch2.await();
        Assert.assertEquals((int)result1.getFails(), (int)0);
        Assert.assertEquals((int)result2.getFails(), (int)0);
    }

    private Thread getThread(final ConcurrencyTestResult concurrencyTestResult, final CountDownLatch latch, final GrizzlyResponseHeaders grizzlyHeaders) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    grizzlyHeaders.getHeaders().keySet();
                }
                catch (Exception e) {
                    concurrencyTestResult.addFail();
                }
                finally {
                    latch.countDown();
                }
            }
        };
    }

    private static final class ConcurrencyTestResult {
        private int fails = 0;

        private ConcurrencyTestResult() {
        }

        public int getFails() {
            return this.fails;
        }

        public void addFail() {
            ++this.fails;
        }
    }
}

