/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class PostWithQSTest
extends AbstractBasicTest {
    @Test(groups={"standalone", "default_provider"})
    public void postWithQS() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture f = client.preparePost("http://127.0.0.1:" + this.port1 + "/?a=b").setBody("abc".getBytes()).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void postWithNulParamQS() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture f = client.preparePost("http://127.0.0.1:" + this.port1 + "/?a=").setBody("abc".getBytes()).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
                    if (!status.getUri().toString().equals("http://127.0.0.1:" + PostWithQSTest.this.port1 + "/?a=")) {
                        throw new IOException(status.getUri().toString());
                    }
                    return super.onStatusReceived(status);
                }
            });
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void postWithNulParamsQS() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture f = client.preparePost("http://127.0.0.1:" + this.port1 + "/?a=b&c&d=e").setBody("abc".getBytes()).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
                    if (!status.getUri().toString().equals("http://127.0.0.1:" + PostWithQSTest.this.port1 + "/?a=b&c&d=e")) {
                        throw new IOException("failed to parse the query properly");
                    }
                    return super.onStatusReceived(status);
                }
            });
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void postWithEmptyParamsQS() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture f = client.preparePost("http://127.0.0.1:" + this.port1 + "/?a=b&c=&d=e").setBody("abc".getBytes()).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
                    if (!status.getUri().toString().equals("http://127.0.0.1:" + PostWithQSTest.this.port1 + "/?a=b&c=&d=e")) {
                        throw new IOException("failed to parse the query properly");
                    }
                    return super.onStatusReceived(status);
                }
            });
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new PostWithQSHandler();
    }

    private class PostWithQSHandler
    extends AbstractHandler {
        private PostWithQSHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("POST".equalsIgnoreCase(request.getMethod())) {
                String qs = request.getQueryString();
                if (MiscUtils.isNonEmpty((String)qs) && request.getContentLength() == 3) {
                    ServletInputStream is = request.getInputStream();
                    response.setStatus(200);
                    byte[] buf = new byte[is.available()];
                    is.readLine(buf, 0, is.available());
                    ServletOutputStream os = response.getOutputStream();
                    os.println(new String(buf));
                    os.flush();
                    os.close();
                } else {
                    response.sendError(406);
                }
            } else {
                response.sendError(403);
            }
        }
    }
}

