/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class NonAsciiContentLengthTest
extends AbstractBasicTest {
    public void setUpServer() throws Exception {
        this.server = new Server();
        this.port1 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        this.server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                int MAX_BODY_SIZE = 1024;
                byte[] b = new byte[MAX_BODY_SIZE];
                int offset = 0;
                try (ServletInputStream is = request.getInputStream();){
                    int numBytesRead;
                    while ((numBytesRead = is.read(b, offset, MAX_BODY_SIZE - offset)) != -1) {
                        offset += numBytesRead;
                    }
                }
                Assert.assertEquals((int)request.getContentLength(), (int)offset);
                response.setStatus(200);
                response.setCharacterEncoding(request.getCharacterEncoding());
                response.setContentLength(request.getContentLength());
                try (ServletOutputStream os = response.getOutputStream();){
                    os.write(b, 0, offset);
                }
            }
        });
        this.server.start();
    }

    @Test(groups={"standalone", "default_provider"})
    public void testNonAsciiContentLength() throws Exception {
        this.setUpServer();
        this.execute("test");
        this.execute("\u4e00");
    }

    protected void execute(String body) throws IOException, InterruptedException, ExecutionException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder r = (AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(body).setBodyEncoding("UTF-8");
            ListenableFuture f = r.execute();
            Response resp = (Response)f.get();
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)body, (String)resp.getResponseBody("UTF-8"));
        }
    }
}

