/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.ws;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.io.IOException;
import java.net.ServerSocket;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractBasicTest
extends Server {
    protected final Logger log = LoggerFactory.getLogger(AbstractBasicTest.class);
    protected int port1;
    ServerConnector _connector;

    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.stop();
    }

    protected int findFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    protected String getTargetUrl() {
        return String.format("ws://127.0.0.1:%d/", this.port1);
    }

    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.port1 = this.findFreePort();
        this._connector = new ServerConnector(this.getServer());
        this._connector.setPort(this.port1);
        this.addConnector((Connector)this._connector);
        WebSocketServlet _wsHandler = this.getWebSocketHandler();
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.getServer().setHandler((Handler)context);
        ServletHolder echo = new ServletHolder((Servlet)_wsHandler);
        context.addServlet(echo, "/*");
        this.start();
        this.log.info("Local HTTP server started successfully");
    }

    public abstract WebSocketServlet getWebSocketHandler();

    public abstract AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig var1);
}

