/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.testng.annotations.Test;

public abstract class FollowingThreadTest
extends AbstractBasicTest {
    private static final int COUNT = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L, groups={"online", "default_provider", "scalability"})
    public void testFollowRedirect() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        final CountDownLatch countDown = new CountDownLatch(10);
        ExecutorService pool = Executors.newCachedThreadPool();
        try {
            for (int i = 0; i < 10; ++i) {
                pool.submit(new Runnable(){
                    private int status;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        final CountDownLatch l = new CountDownLatch(1);
                        try (AsyncHttpClient client = FollowingThreadTest.this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build());){
                            client.prepareGet("http://www.google.com/").execute((AsyncHandler)new AsyncHandler<Integer>(){

                                public void onThrowable(Throwable t) {
                                    t.printStackTrace();
                                }

                                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                                    System.out.println(new String(bodyPart.getBodyPartBytes()));
                                    return AsyncHandler.STATE.CONTINUE;
                                }

                                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                                    status = responseStatus.getStatusCode();
                                    System.out.println(responseStatus.getStatusText());
                                    return AsyncHandler.STATE.CONTINUE;
                                }

                                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                                    return AsyncHandler.STATE.CONTINUE;
                                }

                                public Integer onCompleted() throws Exception {
                                    l.countDown();
                                    return status;
                                }
                            });
                            l.await();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            countDown.countDown();
                        }
                    }
                });
            }
            countDown.await();
        }
        finally {
            pool.shutdown();
        }
    }
}

