/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class ZeroCopyFileTest
extends AbstractBasicTest {
    @Test(groups={"standalone", "default_provider"})
    public void zeroCopyPostTest() throws IOException, ExecutionException, TimeoutException, InterruptedException, URISyntaxException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            final AtomicBoolean headerSent = new AtomicBoolean(false);
            final AtomicBoolean operationCompleted = new AtomicBoolean(false);
            ListenableFuture f = ((AsyncHttpClient.BoundRequestBuilder)client.preparePost("http://127.0.0.1:" + this.port1 + "/").setBody(file)).execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public AsyncHandler.STATE onHeaderWriteCompleted() {
                    headerSent.set(true);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onContentWriteCompleted() {
                    operationCompleted.set(true);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Response onCompleted(Response response) throws Exception {
                    return response;
                }
            });
            Response resp = (Response)f.get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)"This is a simple test file");
            Assert.assertTrue((boolean)operationCompleted.get());
            Assert.assertTrue((boolean)headerSent.get());
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void zeroCopyPutTest() throws IOException, ExecutionException, TimeoutException, InterruptedException, URISyntaxException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            ListenableFuture f = ((AsyncHttpClient.BoundRequestBuilder)client.preparePut("http://127.0.0.1:" + this.port1 + "/").setBody(file)).execute();
            Response resp = (Response)f.get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)"This is a simple test file");
        }
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ZeroCopyHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void zeroCopyFileTest() throws IOException, ExecutionException, TimeoutException, InterruptedException, URISyntaxException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            File tmp = new File(System.getProperty("java.io.tmpdir") + File.separator + "zeroCopy.txt");
            tmp.deleteOnExit();
            final FileOutputStream stream = new FileOutputStream(tmp);
            ListenableFuture f = ((AsyncHttpClient.BoundRequestBuilder)client.preparePost("http://127.0.0.1:" + this.port1 + "/").setBody(file)).execute((AsyncHandler)new AsyncHandler<Response>(){

                public void onThrowable(Throwable t) {
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    bodyPart.writeTo((OutputStream)stream);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Response onCompleted() throws Exception {
                    return null;
                }
            });
            Response resp = (Response)f.get();
            stream.close();
            Assert.assertNull((Object)resp);
            Assert.assertEquals((long)file.length(), (long)tmp.length());
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void zeroCopyFileWithBodyManipulationTest() throws IOException, ExecutionException, TimeoutException, InterruptedException, URISyntaxException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            File tmp = new File(System.getProperty("java.io.tmpdir") + File.separator + "zeroCopy.txt");
            tmp.deleteOnExit();
            final FileOutputStream stream = new FileOutputStream(tmp);
            ListenableFuture f = ((AsyncHttpClient.BoundRequestBuilder)client.preparePost("http://127.0.0.1:" + this.port1 + "/").setBody(file)).execute((AsyncHandler)new AsyncHandler<Response>(){

                public void onThrowable(Throwable t) {
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    bodyPart.writeTo((OutputStream)stream);
                    if (bodyPart.getBodyPartBytes().length == 0) {
                        return AsyncHandler.STATE.ABORT;
                    }
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Response onCompleted() throws Exception {
                    return null;
                }
            });
            Response resp = (Response)f.get();
            stream.close();
            Assert.assertNull((Object)resp);
            Assert.assertEquals((long)file.length(), (long)tmp.length());
        }
    }

    private class ZeroCopyHandler
    extends AbstractHandler {
        private ZeroCopyHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            byte[] bytes;
            int size = 10240;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            if ((bytes = new byte[size]).length > 0) {
                httpRequest.getInputStream().read(bytes);
                httpResponse.getOutputStream().write(bytes);
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
        }
    }
}

