/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.NonBlockingInputStreamFeeder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import org.glassfish.grizzly.Buffer;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NonBlockingInputStreamFeederTest {
    private static final byte[] DATA = "Hello, world!".getBytes();
    private static final byte[] EMPTY = new byte[0];

    @Test
    public void feedSmallPayload() throws IOException {
        this.assertFeeding(DATA);
    }

    @Test
    public void feedEmptyPayload() throws IOException {
        this.assertFeeding(EMPTY);
    }

    private void assertFeeding(byte[] data) throws IOException {
        int bufferSize = data.length / 2;
        LinkedList buffers = new LinkedList();
        NonBlockingInputStreamFeeder nonBlockingInputStreamFeeder = new NonBlockingInputStreamFeeder(new FeedableBodyGenerator(), (InputStream)new ByteArrayInputStream(data), bufferSize);
        NonBlockingInputStreamFeeder mockedFeeder = (NonBlockingInputStreamFeeder)Mockito.spy((Object)nonBlockingInputStreamFeeder);
        ((NonBlockingInputStreamFeeder)Mockito.doAnswer(a -> {
            buffers.add(a.getArgument(0));
            return null;
        }).when((Object)mockedFeeder)).feed((Buffer)Mockito.any(Buffer.class), Mockito.anyBoolean());
        while (mockedFeeder.isReady()) {
            mockedFeeder.canFeed();
        }
        byte[] received = buffers.stream().reduce(new byte[0], (acc, buff) -> NonBlockingInputStreamFeederTest.addAll(acc, Arrays.copyOfRange(buff.array(), buff.position(), buff.remaining())), (arr1, arr2) -> NonBlockingInputStreamFeederTest.addAll(arr1, arr2));
        Assert.assertEquals((byte[])received, (byte[])data);
    }

    private static byte[] addAll(byte[] one, byte[] two) {
        byte[] result = Arrays.copyOf(one, one.length + two.length);
        System.arraycopy(two, 0, result, one.length, two.length);
        return result;
    }
}

