/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class RedirectConnectionUsageTest
extends AbstractBasicTest {
    private String BASE_URL;
    private String servletEndpointRedirectUrl;

    @BeforeClass
    public void setUp() throws Exception {
        this.server = new Server();
        this.port1 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("localhost");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new MockRedirectHttpServlet()), "/redirect/*");
        context.addServlet(new ServletHolder((Servlet)new MockFullResponseHttpServlet()), "/*");
        this.server.start();
        this.BASE_URL = "http://localhost:" + this.port1;
        this.servletEndpointRedirectUrl = this.BASE_URL + "/redirect";
    }

    @AfterClass
    public void tearDown() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            System.err.print("Error stopping servlet tester");
            e.printStackTrace();
        }
    }

    @Test
    public void testGetRedirectFinalUrl() {
        AsyncHttpClientConfig.Builder bc = new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setMaxConnectionsPerHost(1).setMaxConnections(1).setConnectTimeout(1000).setRequestTimeout(1000).setFollowRedirect(true);
        try (AsyncHttpClient client = this.getAsyncHttpClient(bc.build());){
            RequestBuilder builder = new RequestBuilder("GET");
            builder.setUrl(this.servletEndpointRedirectUrl);
            Request r = builder.build();
            try {
                ListenableFuture response = client.executeRequest(r);
                Response res = null;
                res = (Response)response.get();
                Assert.assertNotNull((Object)res.getResponseBody());
                Assert.assertEquals((String)(this.BASE_URL + "/overthere"), (String)(this.BASE_URL + "/overthere"), (String)res.getUri().toString());
            }
            catch (Exception e) {
                System.err.print("============");
                e.printStackTrace();
                System.err.print("============");
                System.err.flush();
                FileAssert.fail((String)"Should not get here, The request threw an exception");
            }
        }
    }

    protected abstract AsyncHttpProviderConfig getProviderConfig();

    class MockFullResponseHttpServlet
    extends HttpServlet {
        private static final String contentType = "text/xml";
        private static final String xml = "<?xml version=\"1.0\"?><hello date=\"%s\"></hello>";

        MockFullResponseHttpServlet() {
        }

        public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
            String xmlToReturn = String.format(xml, new Date().toString());
            res.setStatus(200);
            res.addHeader("Content-Type", contentType);
            res.addHeader("X-Method", req.getMethod());
            res.addHeader("MultiValue", "1");
            res.addHeader("MultiValue", "2");
            res.addHeader("MultiValue", "3");
            ServletOutputStream os = res.getOutputStream();
            byte[] retVal = xmlToReturn.getBytes();
            res.setContentLength(retVal.length);
            os.write(retVal);
            os.close();
        }
    }

    class MockRedirectHttpServlet
    extends HttpServlet {
        MockRedirectHttpServlet() {
        }

        public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            res.sendRedirect("/overthere");
        }
    }
}

