/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.NonBlockingInputStreamFeeder;
import com.ning.http.client.uri.Uri;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class LargePayloadStreamingTest
extends AbstractBasicTest {
    private CountDownLatch requestEndedLatch;

    private AsyncHttpClientConfig configureClient() {
        return new AsyncHttpClientConfig.Builder().setRequestTimeout(100000).build();
    }

    @BeforeMethod
    public void setUp() {
        this.requestEndedLatch = new CountDownLatch(1);
    }

    @Test(groups={"standalone", "default_provider"})
    public void largePayloadGetsStreamedSuccessfully() throws InterruptedException, ExecutionException {
        this.assertPayloadOfSizeGetsStreamedCorrectly("1GB");
    }

    @Test(groups={"standalone", "default_provider"})
    public void littlePayloadGetsStreamedSuccessfully() throws InterruptedException, ExecutionException {
        this.assertPayloadOfSizeGetsStreamedCorrectly("200B");
    }

    @Test(groups={"standalone", "default_provider"})
    public void increasingPayloadSizeWarmsUpClient() throws ExecutionException, InterruptedException {
        List<String> payloadSizes = Arrays.asList("100MB", "300MB", "600MB", "800MB", "1GB");
        for (String aSize : payloadSizes) {
            this.assertPayloadOfSizeGetsStreamedCorrectly(aSize);
            Thread.sleep(1000L);
        }
    }

    private void assertPayloadOfSizeGetsStreamedCorrectly(String payloadSize) throws InterruptedException, ExecutionException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(this.configureClient());){
            ListenableFuture<Response> response = this.executeAsyncRequest(client, payloadSize);
            this.requestEndedLatch.await();
            Assert.assertEquals((int)((Response)response.get()).getStatusCode(), (int)200);
        }
    }

    private ListenableFuture<Response> executeAsyncRequest(AsyncHttpClient client, Long payloadSize) {
        RequestBuilder requestBuilder = new RequestBuilder();
        requestBuilder.setMethod("POST");
        FeedableBodyGenerator generator = new FeedableBodyGenerator();
        NonBlockingInputStreamFeeder feeder = new NonBlockingInputStreamFeeder(generator, (InputStream)new FixedSizeRandomInputStream(payloadSize));
        generator.setFeeder((FeedableBodyGenerator.Feeder)feeder);
        requestBuilder.setBody((BodyGenerator)generator);
        requestBuilder.setUri(Uri.create((String)this.getTargetUrl()));
        return client.executeRequest(requestBuilder.build(), (AsyncHandler)new ResponseAsyncHandler());
    }

    private ListenableFuture<Response> executeAsyncRequest(AsyncHttpClient client, String payloadSize) {
        Long actualPayloadSize = this.toBytes(payloadSize);
        return this.executeAsyncRequest(client, actualPayloadSize);
    }

    private Long toBytes(String aSize) {
        Matcher numberMatcher = Pattern.compile("([0-9]+)[A-Za-z]+").matcher(aSize);
        Matcher unitMatcher = Pattern.compile("^[0-9]+([A-Za-z]+)$").matcher(aSize);
        numberMatcher.find();
        unitMatcher.find();
        Long foundNumber = Long.parseLong(numberMatcher.group(1));
        String foundUnit = unitMatcher.group(1).toUpperCase();
        if (foundUnit.equals("GB")) {
            return foundNumber * 0x40000000L;
        }
        if (foundUnit.equals("MB")) {
            return foundNumber * 0x100000L;
        }
        if (foundUnit.equals("KB")) {
            return foundNumber * 1024L;
        }
        return foundNumber;
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new StreamReceivingHandler();
    }

    private class StreamReceivingHandler
    extends AbstractHandler {
        private StreamReceivingHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("POST".equals(request.getMethod())) {
                while (request.getInputStream().read() != -1) {
                }
                response.setStatus(200);
            } else {
                response.sendError(500);
            }
            response.getOutputStream().flush();
            response.getOutputStream().close();
            baseRequest.setHandled(true);
        }
    }

    private class ResponseAsyncHandler
    extends AsyncCompletionHandler<Response> {
        private ResponseAsyncHandler() {
        }

        public Response onCompleted(Response response) throws Exception {
            LargePayloadStreamingTest.this.requestEndedLatch.countDown();
            return response;
        }
    }

    private class FixedSizeRandomInputStream
    extends InputStream {
        private Random randomGenerator = new Random();
        private final Long size;
        private Long index;

        public FixedSizeRandomInputStream(Long streamSize) {
            this.size = streamSize;
            this.index = 0L;
        }

        @Override
        public int read() throws IOException {
            if (this.index.equals(this.size)) {
                return -1;
            }
            Long l = this.index;
            Long l2 = this.index = Long.valueOf(this.index + 1L);
            return this.randomGenerator.nextInt(256);
        }
    }
}

