/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.ws;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ws.AbstractBasicTest;
import com.ning.http.client.ws.EchoTextWebSocketServlet;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketListener;
import com.ning.http.client.ws.WebSocketTextListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class TextMessageTest
extends AbstractBasicTest {
    @Override
    public WebSocketServlet getWebSocketHandler() {
        return new EchoTextWebSocketServlet();
    }

    @Test(timeOut=60000L)
    public void onOpen() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                    text.set("OnOpen");
                    latch.countDown();
                }

                public void onClose(WebSocket websocket) {
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnOpen");
        }
    }

    @Test(timeOut=60000L)
    public void onEmptyListenerTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            WebSocket websocket = null;
            try {
                websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().build()).get();
            }
            catch (Throwable t) {
                Assert.fail();
            }
            Assert.assertTrue((websocket != null ? 1 : 0) != 0);
        }
    }

    @Test(timeOut=60000L, expectedExceptions={ConnectException.class, UnresolvedAddressException.class, UnknownHostException.class})
    public void onFailureTest() throws Throwable {
        try (AsyncHttpClient c = this.getAsyncHttpClient(null);){
            c.prepareGet("ws://abcdefg").execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().build()).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    @Test(timeOut=60000L)
    public void onTimeoutCloseTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    text.set("OnClose");
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnClose");
        }
    }

    @Test(timeOut=60000L)
    public void onClose() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    text.set("OnClose");
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.close();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnClose");
        }
    }

    @Test(timeOut=60000L)
    public void echoText() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set(message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO");
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHO");
        }
    }

    @Test(timeOut=60000L)
    public void echoDoubleListenerText() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set(message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set((String)text.get() + message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO");
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHOECHO");
        }
    }

    @Test
    public void echoTwoMessagesTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set((String)text.get() + message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                    websocket.sendMessage("ECHO").sendMessage("ECHO");
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHOECHO");
        }
    }

    public void echoFragments() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set(message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.stream("ECHO", false);
            websocket.stream("ECHO", true);
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHOECHO");
        }
    }

    @Test(timeOut=60000L)
    public void echoTextAndThenClose() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch textLatch = new CountDownLatch(1);
            final CountDownLatch closeLatch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set((String)text.get() + message);
                    textLatch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    closeLatch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    closeLatch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO");
            textLatch.await();
            websocket.sendMessage("CLOSE");
            closeLatch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHO");
        }
    }
}

