/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.BodyConsumer;
import com.ning.http.client.Response;
import com.ning.http.client.SimpleAsyncHttpClient;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.consumers.OutputStreamBodyConsumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleAsyncClientErrorBehaviourTest
extends AbstractBasicTest {
    @Test(groups={"standalone", "default_provider"})
    public void testAccumulateErrorBody() throws Throwable {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setUrl(this.getTargetUrl() + "/nonexistent").setErrorDocumentBehaviour(SimpleAsyncHttpClient.ErrorDocumentBehaviour.ACCUMULATE).build();){
            ByteArrayOutputStream o = new ByteArrayOutputStream(10);
            Future future = client.get((BodyConsumer)new OutputStreamBodyConsumer((OutputStream)o));
            System.out.println("waiting for response");
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)404);
            Assert.assertEquals((String)o.toString(), (String)"");
            Assert.assertTrue((boolean)response.getResponseBody().startsWith("<html>"));
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testOmitErrorBody() throws Throwable {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setUrl(this.getTargetUrl() + "/nonexistent").setErrorDocumentBehaviour(SimpleAsyncHttpClient.ErrorDocumentBehaviour.OMIT).build();){
            ByteArrayOutputStream o = new ByteArrayOutputStream(10);
            Future future = client.get((BodyConsumer)new OutputStreamBodyConsumer((OutputStream)o));
            System.out.println("waiting for response");
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)404);
            Assert.assertEquals((String)o.toString(), (String)"");
            Assert.assertEquals((String)response.getResponseBody(), (String)"");
        }
    }

    @Override
    public AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig config) {
        return null;
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                response.sendError(404);
                baseRequest.setHandled(true);
            }
        };
    }
}

