/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.SimpleAsyncHttpClient;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class ProxyTunnellingTest
extends AbstractBasicTest {
    private Server server2;

    public HandlerWrapper configureHandler() throws Exception {
        return new ConnectHandler();
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.server2 = new Server();
        this.port1 = this.findFreePort();
        this.port2 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        HttpConfiguration https_config = new HttpConfiguration();
        https_config.setSecureScheme("https");
        https_config.setSecurePort(this.port2);
        https_config.setOutputBufferSize(32768);
        SslContextFactory sslContextFactory = new SslContextFactory();
        ClassLoader cl = this.getClass().getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        String trustStoreFile = new File(cacertsUrl.toURI()).getAbsolutePath();
        sslContextFactory.setTrustStorePath(trustStoreFile);
        sslContextFactory.setTrustStorePassword("changeit");
        sslContextFactory.setTrustStoreType("JKS");
        this.log.info("SSL certs path: {}", (Object)trustStoreFile);
        URL keystoreUrl = cl.getResource("ssltest-keystore.jks");
        String keystoreFile = new File(keystoreUrl.toURI()).getAbsolutePath();
        sslContextFactory.setKeyStorePath(keystoreFile);
        sslContextFactory.setKeyStorePassword("changeit");
        sslContextFactory.setKeyStoreType("JKS");
        this.log.info("SSL keystore path: {}", (Object)trustStoreFile);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(2000L);
        src.setStsIncludeSubDomains(true);
        https_config.addCustomizer((HttpConfiguration.Customizer)src);
        ServerConnector connector = new ServerConnector(this.server2, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        connector.setHost("127.0.0.1");
        connector.setPort(this.port2);
        this.server2.addConnector((Connector)connector);
        this.server.setHandler((Handler)this.configureHandler());
        this.server.start();
        this.server2.setHandler((Handler)new AbstractBasicTest.EchoHandler());
        this.server2.start();
        this.log.info("Local HTTP server started successfully");
    }

    @Test(groups={"online", "default_provider"})
    public void testRequestProxy() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        ProxyServer ps = new ProxyServer(ProxyServer.Protocol.HTTPS, "127.0.0.1", this.port1);
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            RequestBuilder rb = new RequestBuilder("GET").setProxyServer(ps).setUrl(this.getTargetUrl2());
            ListenableFuture responseFuture = client.executeRequest(rb.build(), (AsyncHandler)new AsyncCompletionHandlerBase(){

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    ProxyTunnellingTest.this.log.debug(t.getMessage(), t);
                }

                public Response onCompleted(Response response) throws Exception {
                    return response;
                }
            });
            Response r = (Response)responseFuture.get();
            Assert.assertEquals((int)r.getStatusCode(), (int)200);
            Assert.assertEquals((String)r.getHeader("X-Connection"), (String)"keep-alive");
        }
    }

    @Test(groups={"online", "default_provider"})
    public void testConfigProxy() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setProxyServer(new ProxyServer(ProxyServer.Protocol.HTTPS, "127.0.0.1", this.port1)).setAcceptAnyCertificate(true).setFollowRedirect(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            RequestBuilder rb = new RequestBuilder("GET").setUrl(this.getTargetUrl2());
            ListenableFuture responseFuture = client.executeRequest(rb.build(), (AsyncHandler)new AsyncCompletionHandlerBase(){

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    ProxyTunnellingTest.this.log.debug(t.getMessage(), t);
                }

                public Response onCompleted(Response response) throws Exception {
                    return response;
                }
            });
            Response r = (Response)responseFuture.get();
            Assert.assertEquals((int)r.getStatusCode(), (int)200);
            Assert.assertEquals((String)r.getHeader("X-Connection"), (String)"keep-alive");
        }
    }

    @Test(groups={"online", "default_provider"})
    public void testSimpleAHCConfigProxy() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        try (SimpleAsyncHttpClient client = new SimpleAsyncHttpClient.Builder().setProxyProtocol(ProxyServer.Protocol.HTTPS).setProxyHost("127.0.0.1").setProxyPort(this.port1).setFollowRedirects(true).setUrl(this.getTargetUrl2()).setAcceptAnyCertificate(true).setHeader("Content-Type", "text/html").build();){
            Response r = (Response)client.get().get();
            Assert.assertEquals((int)r.getStatusCode(), (int)200);
            Assert.assertEquals((String)r.getHeader("X-Connection"), (String)"keep-alive");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testNonProxyHostsSsl() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Response resp = (Response)((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl2()).setProxyServer(new ProxyServer("127.0.0.1", this.port1 - 1).addNonProxyHost("127.0.0.1"))).execute().get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("X-pathInfo"), (String)"/foo/test");
        }
    }
}

