/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class ProxyTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ProxyHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void testRequestLevelProxy() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            String target = "http://127.0.0.1:1234/";
            ListenableFuture f = ((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(target).setProxyServer(new ProxyServer("127.0.0.1", this.port1))).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testGlobalProxy() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        AsyncHttpClientConfig cfg = new AsyncHttpClientConfig.Builder().setProxyServer(new ProxyServer("127.0.0.1", this.port1)).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cfg);){
            String target = "http://127.0.0.1:1234/";
            ListenableFuture f = client.prepareGet(target).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testBothProxies() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        AsyncHttpClientConfig cfg = new AsyncHttpClientConfig.Builder().setProxyServer(new ProxyServer("127.0.0.1", this.port1 - 1)).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cfg);){
            String target = "http://127.0.0.1:1234/";
            ListenableFuture f = ((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(target).setProxyServer(new ProxyServer("127.0.0.1", this.port1))).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testNonProxyHosts() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        AsyncHttpClientConfig cfg = new AsyncHttpClientConfig.Builder().setProxyServer(new ProxyServer("127.0.0.1", this.port1 - 1)).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cfg);){
            String target = "http://127.0.0.1:1234/";
            ((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(target).setProxyServer(new ProxyServer("127.0.0.1", this.port1).addNonProxyHost("127.0.0.1"))).execute().get();
            Assert.assertFalse((boolean)true);
        }
        catch (Throwable e) {
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertEquals(e.getCause().getClass(), ConnectException.class);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testNonProxyHostIssue202() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            String target = "http://127.0.0.1:" + this.port1 + "/";
            ListenableFuture f = ((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(target).setProxyServer(new ProxyServer("127.0.0.1", this.port1 - 1).addNonProxyHost("127.0.0.1"))).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void testProxyProperties() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        Properties originalProps = System.getProperties();
        try {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)originalProps);
            System.setProperties(props);
            System.setProperty("http.proxyHost", "127.0.0.1");
            System.setProperty("http.proxyPort", String.valueOf(this.port1));
            System.setProperty("http.nonProxyHosts", "localhost");
            AsyncHttpClientConfig cfg = new AsyncHttpClientConfig.Builder().setUseProxyProperties(true).build();
            try (AsyncHttpClient client = this.getAsyncHttpClient(cfg);){
                String target = "http://127.0.0.1:1234/";
                ListenableFuture f = client.prepareGet(target).execute();
                Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
                Assert.assertNotNull((Object)resp);
                Assert.assertEquals((int)resp.getStatusCode(), (int)200);
                Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
                target = "http://localhost:1234/";
                f = client.prepareGet(target).execute();
                try {
                    resp = (Response)f.get(3L, TimeUnit.SECONDS);
                    Assert.fail((String)"should not be able to connect");
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }
        finally {
            System.setProperties(originalProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void testIgnoreProxyPropertiesByDefault() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        Properties originalProps = System.getProperties();
        try {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)originalProps);
            System.setProperties(props);
            System.setProperty("http.proxyHost", "127.0.0.1");
            System.setProperty("http.proxyPort", String.valueOf(this.port1));
            System.setProperty("http.nonProxyHosts", "localhost");
            try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
                String target = "http://127.0.0.1:1234/";
                ListenableFuture f = client.prepareGet(target).execute();
                try {
                    f.get(3L, TimeUnit.SECONDS);
                    Assert.fail((String)"should not be able to connect");
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }
        finally {
            System.setProperties(originalProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void testProxyActivationProperty() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        Properties originalProps = System.getProperties();
        try {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)originalProps);
            System.setProperties(props);
            System.setProperty("http.proxyHost", "127.0.0.1");
            System.setProperty("http.proxyPort", String.valueOf(this.port1));
            System.setProperty("http.nonProxyHosts", "localhost");
            System.setProperty("com.ning.http.client.AsyncHttpClientConfig.useProxyProperties", "true");
            try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
                String target = "http://127.0.0.1:1234/";
                ListenableFuture f = client.prepareGet(target).execute();
                Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
                Assert.assertNotNull((Object)resp);
                Assert.assertEquals((int)resp.getStatusCode(), (int)200);
                Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
                target = "http://localhost:1234/";
                f = client.prepareGet(target).execute();
                try {
                    resp = (Response)f.get(3L, TimeUnit.SECONDS);
                    Assert.fail((String)"should not be able to connect");
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }
        finally {
            System.setProperties(originalProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void testWildcardNonProxyHosts() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        Properties originalProps = System.getProperties();
        try {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)originalProps);
            System.setProperties(props);
            System.setProperty("http.proxyHost", "127.0.0.1");
            System.setProperty("http.proxyPort", String.valueOf(this.port1));
            System.setProperty("http.nonProxyHosts", "127.*");
            AsyncHttpClientConfig cfg = new AsyncHttpClientConfig.Builder().setUseProxyProperties(true).build();
            try (AsyncHttpClient client = this.getAsyncHttpClient(cfg);){
                String target = "http://127.0.0.1:1234/";
                ListenableFuture f = client.prepareGet(target).execute();
                try {
                    f.get(3L, TimeUnit.SECONDS);
                    Assert.fail((String)"should not be able to connect");
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }
        finally {
            System.setProperties(originalProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"standalone", "default_provider"})
    public void testUseProxySelector() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        ProxySelector originalProxySelector = ProxySelector.getDefault();
        try {
            ProxySelector.setDefault(new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    if (uri.getHost().equals("127.0.0.1")) {
                        return Arrays.asList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("127.0.0.1", ProxyTest.this.port1)));
                    }
                    return Arrays.asList(Proxy.NO_PROXY);
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            });
            AsyncHttpClientConfig cfg = new AsyncHttpClientConfig.Builder().setUseProxySelector(true).build();
            try (AsyncHttpClient client = this.getAsyncHttpClient(cfg);){
                String target = "http://127.0.0.1:1234/";
                ListenableFuture f = client.prepareGet(target).execute();
                Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
                Assert.assertNotNull((Object)resp);
                Assert.assertEquals((int)resp.getStatusCode(), (int)200);
                Assert.assertEquals((String)resp.getHeader("target"), (String)"/");
                target = "http://localhost:1234/";
                f = client.prepareGet(target).execute();
                try {
                    f.get(3L, TimeUnit.SECONDS);
                    Assert.fail((String)"should not be able to connect");
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }
        finally {
            ProxySelector.setDefault(originalProxySelector);
        }
    }

    private class ProxyHandler
    extends HandlerWrapper {
        private ProxyHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("GET".equalsIgnoreCase(request.getMethod())) {
                response.addHeader("target", r.getHttpURI().getPath());
                response.setStatus(200);
            } else {
                response.sendError(403);
            }
            r.setHandled(true);
        }
    }
}

