/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.util.ProxyUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProxyUtilsTest {
    @Test(groups={"fast"})
    public void testBasics() {
        Request req = new RequestBuilder("GET").setUrl("http://somewhere.com/foo").build();
        Assert.assertTrue((boolean)ProxyUtils.avoidProxy(null, (Request)req));
        req = new RequestBuilder("GET").setUrl("http://somewhere.com/foo").build();
        ProxyServer proxyServer = new ProxyServer("foo", 1234);
        proxyServer.addNonProxyHost("somewhere.com");
        Assert.assertTrue((boolean)ProxyUtils.avoidProxy((ProxyServer)proxyServer, (Request)req));
        req = new RequestBuilder("GET").setUrl("http://sub.somewhere.com/foo").build();
        proxyServer = new ProxyServer("foo", 1234);
        proxyServer.addNonProxyHost("*.somewhere.com");
        Assert.assertTrue((boolean)ProxyUtils.avoidProxy((ProxyServer)proxyServer, (Request)req));
        req = new RequestBuilder("GET").setUrl("http://sub.somewhere.com/foo").build();
        proxyServer = new ProxyServer("foo", 1234);
        proxyServer.addNonProxyHost("*.somewhere.org");
        Assert.assertFalse((boolean)ProxyUtils.avoidProxy((ProxyServer)proxyServer, (Request)req));
    }
}

