/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.async.ChunkingTest;
import com.ning.http.client.multipart.FilePart;
import com.ning.http.client.multipart.Part;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.Test;

public abstract class FilePartLargeFileTest
extends AbstractBasicTest {
    private static final File TMP = new File(System.getProperty("java.io.tmpdir"), "ahc-tests-" + UUID.randomUUID().toString().substring(0, 8));

    @Test(groups={"standalone", "default_provider"}, enabled=true)
    public void testPutImageFile() throws Exception {
        File largeFile = FilePartLargeFileTest.getTestFile();
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setRequestTimeout(600000).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            AsyncHttpClient.BoundRequestBuilder rb = client.preparePut(this.getTargetUrl());
            rb.addBodyPart((Part)new FilePart("test", largeFile, "application/octet-stream", StandardCharsets.UTF_8));
            Response response = (Response)rb.execute().get();
            Assert.assertEquals((int)200, (int)response.getStatusCode());
        }
    }

    @Test(groups={"standalone", "default_provider"}, enabled=true)
    public void testPutLargeTextFile() throws Exception {
        byte[] bytes = "RatherLargeFileRatherLargeFileRatherLargeFileRatherLargeFile".getBytes(StandardCharsets.UTF_16);
        long repeats = 0x100000 / bytes.length + 1;
        File largeFile = FilePartLargeFileTest.createTempFile(bytes, (int)repeats);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder rb = client.preparePut(this.getTargetUrl());
            rb.addBodyPart((Part)new FilePart("test", largeFile, "application/octet-stream", StandardCharsets.UTF_8));
            Response response = (Response)rb.execute().get();
            Assert.assertEquals((int)200, (int)response.getStatusCode());
        }
    }

    private static File getTestFile() {
        String testResource1 = "300k.png";
        File testResource1File = null;
        try {
            ClassLoader cl = ChunkingTest.class.getClassLoader();
            URL url = cl.getResource(testResource1);
            testResource1File = new File(url.toURI());
        }
        catch (Throwable e) {
            FileAssert.fail((String)("unable to find " + testResource1));
        }
        return testResource1File;
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String arg0, Request arg1, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                ServletInputStream in = req.getInputStream();
                byte[] b = new byte[8192];
                int count = -1;
                int total = 0;
                while ((count = in.read(b)) != -1) {
                    b = new byte[8192];
                    total += count;
                }
                System.err.println("consumed " + total + " bytes.");
                resp.setStatus(200);
                resp.addHeader("X-TRANFERED", String.valueOf(total));
                resp.getOutputStream().flush();
                resp.getOutputStream().close();
                arg1.setHandled(true);
            }
        };
    }

    public static File createTempFile(byte[] pattern, int repeat) throws IOException {
        TMP.mkdirs();
        TMP.deleteOnExit();
        File tmpFile = File.createTempFile("tmpfile-", ".data", TMP);
        tmpFile.deleteOnExit();
        FilePartLargeFileTest.write(pattern, repeat, tmpFile);
        return tmpFile;
    }

    public static void write(byte[] pattern, int repeat, File file) throws IOException {
        file.deleteOnExit();
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(file);){
            for (int i = 0; i < repeat; ++i) {
                out.write(pattern);
            }
        }
    }
}

