/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class NoNullResponseTest
extends AbstractBasicTest {
    private static final String VERISIGN_HTTPS_URL = "https://www.verisign.com";

    @Test(invocationCount=4, groups={"online", "default_provider"})
    public void multipleSslRequestsWithDelayAndKeepAlive() throws Throwable {
        AsyncHttpClientConfig.Builder configBuilder = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).setSSLContext(this.getSSLContext()).setAllowPoolingConnections(true).setConnectTimeout(10000).setPooledConnectionIdleTimeout(60000).setRequestTimeout(10000).setMaxConnectionsPerHost(-1).setMaxConnections(-1);
        try (AsyncHttpClient client = this.getAsyncHttpClient(configBuilder.build());){
            AsyncHttpClient.BoundRequestBuilder builder = client.prepareGet(VERISIGN_HTTPS_URL);
            Response response1 = (Response)builder.execute().get();
            Thread.sleep(4000L);
            Response response2 = (Response)builder.execute().get();
            if (response2 != null) {
                System.out.println("Success (2nd response was not null).");
            } else {
                System.out.println("Failed (2nd response was null).");
            }
            Assert.assertNotNull((Object)response1);
            Assert.assertNotNull((Object)response2);
        }
    }

    private SSLContext getSSLContext() throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new MockTrustManager()}, null);
        return sslContext;
    }

    private static class MockTrustManager
    implements X509TrustManager {
        private MockTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

