/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class InputStreamTest
extends AbstractBasicTest {
    @Test(groups={"standalone", "default_provider"})
    public void testInvalidInputStream() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            InputStream is = new InputStream(){
                public int readAllowed;

                @Override
                public int available() {
                    return 1;
                }

                @Override
                public int read() throws IOException {
                    int fakeCount;
                    if ((fakeCount = this.readAllowed++) == 0) {
                        return 97;
                    }
                    if (fakeCount == 1) {
                        return 98;
                    }
                    if (fakeCount == 2) {
                        return 99;
                    }
                    return -1;
                }
            };
            Response resp = (Response)client.preparePost(this.getTargetUrl()).setHeaders(h).setBody(is).execute().get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("X-Param"), (String)"abc");
        }
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new InputStreamHandler();
    }

    private class InputStreamHandler
    extends AbstractHandler {
        private InputStreamHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("POST".equalsIgnoreCase(request.getMethod())) {
                byte[] b = new byte[3];
                request.getInputStream().read(b, 0, 3);
                response.setStatus(200);
                response.addHeader("X-Param", new String(b));
            } else {
                response.sendError(403);
            }
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }
}

