/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class Expect100ContinueTest
extends AbstractBasicTest {
    @Test(groups={"standalone", "default_provider"})
    public void Expect100Continue() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            ListenableFuture f = ((AsyncHttpClient.BoundRequestBuilder)client.preparePut("http://127.0.0.1:" + this.port1 + "/").setHeader("Expect", "100-continue").setBody(file)).execute();
            Response resp = (Response)f.get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)"This is a simple test file");
        }
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ZeroCopyHandler();
    }

    private class ZeroCopyHandler
    extends HandlerWrapper {
        private ZeroCopyHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            byte[] bytes;
            int size = 10240;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            if ((bytes = new byte[size]).length > 0) {
                int read = httpRequest.getInputStream().read(bytes);
                httpResponse.getOutputStream().write(bytes, 0, read);
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
        }
    }
}

