/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.ws.grizzly;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Response;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResponseRefLeak {
    @Test
    public void referencedResponseHC() throws InterruptedException {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().build();
        AsyncHttpClient client = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
        final CountDownLatch responseLatch = new CountDownLatch(1);
        final AtomicReference<Object> responseRef = new AtomicReference<Object>();
        client.prepareGet("http://www.ning.com/").execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

            public Response onCompleted(Response response) throws Exception {
                responseLatch.countDown();
                responseRef.set(response);
                return response;
            }

            public void onThrowable(Throwable t) {
            }
        });
        responseLatch.await(5L, TimeUnit.SECONDS);
        this.verifyNotLeaked(new PhantomReference<Object>(responseRef.getAndSet(null), new ReferenceQueue()));
    }

    private void verifyNotLeaked(PhantomReference possibleLeakPhantomRef) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            System.gc();
            Thread.sleep(100L);
            if (possibleLeakPhantomRef.isEnqueued()) break;
        }
        Assert.assertTrue((boolean)possibleLeakPhantomRef.isEnqueued());
    }
}

