/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.ws;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ws.AbstractBasicTest;
import com.ning.http.client.ws.EchoByteWebSocketServlet;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketByteListener;
import com.ning.http.client.ws.WebSocketListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class ByteMessageTest
extends AbstractBasicTest {
    @Override
    public WebSocketServlet getWebSocketHandler() {
        return new EchoByteWebSocketServlet();
    }

    @Test
    public void echoByte() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<byte[]> text = new AtomicReference<byte[]>(new byte[0]);
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketByteListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onMessage(byte[] message) {
                    text.set(message);
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO".getBytes());
            latch.await();
            Assert.assertEquals((byte[])text.get(), (byte[])"ECHO".getBytes());
        }
    }

    @Test
    public void echoTwoMessagesTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<Object> text = new AtomicReference<Object>(null);
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketByteListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onMessage(byte[] message) {
                    if (text.get() == null) {
                        text.set(message);
                    } else {
                        byte[] n = new byte[((byte[])text.get()).length + message.length];
                        System.arraycopy(text.get(), 0, n, 0, ((byte[])text.get()).length);
                        System.arraycopy(message, 0, n, ((byte[])text.get()).length, message.length);
                        text.set(n);
                    }
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO".getBytes()).sendMessage("ECHO".getBytes());
            latch.await();
            Assert.assertEquals((byte[])text.get(), (byte[])"ECHOECHO".getBytes());
        }
    }

    @Test
    public void echoOnOpenMessagesTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<Object> text = new AtomicReference<Object>(null);
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketByteListener(){

                public void onOpen(WebSocket websocket) {
                    websocket.sendMessage("ECHO".getBytes()).sendMessage("ECHO".getBytes());
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onMessage(byte[] message) {
                    if (text.get() == null) {
                        text.set(message);
                    } else {
                        byte[] n = new byte[((byte[])text.get()).length + message.length];
                        System.arraycopy(text.get(), 0, n, 0, ((byte[])text.get()).length);
                        System.arraycopy(message, 0, n, ((byte[])text.get()).length, message.length);
                        text.set(n);
                    }
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((byte[])text.get(), (byte[])"ECHOECHO".getBytes());
        }
    }

    public void echoFragments() throws Exception {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<Object> text = new AtomicReference<Object>(null);
            WebSocket websocket = (WebSocket)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketByteListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }

                public void onMessage(byte[] message) {
                    if (text.get() == null) {
                        text.set(message);
                    } else {
                        byte[] n = new byte[((byte[])text.get()).length + message.length];
                        System.arraycopy(text.get(), 0, n, 0, ((byte[])text.get()).length);
                        System.arraycopy(message, 0, n, ((byte[])text.get()).length, message.length);
                        text.set(n);
                    }
                    latch.countDown();
                }
            }).build()).get();
            websocket.stream("ECHO".getBytes(), false);
            websocket.stream("ECHO".getBytes(), true);
            latch.await();
            Assert.assertEquals((byte[])text.get(), (byte[])"ECHOECHO".getBytes());
        }
    }
}

