/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.generators;

import com.ning.http.client.Body;
import com.ning.http.client.generators.ByteArrayBodyGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ByteArrayBodyGeneratorTest {
    private final Random random = new Random();
    private final int chunkSize = 8192;

    @Test(groups={"standalone"})
    public void testSingleRead() throws IOException {
        int srcArraySize = 8191;
        byte[] srcArray = new byte[8191];
        this.random.nextBytes(srcArray);
        ByteArrayBodyGenerator babGen = new ByteArrayBodyGenerator(srcArray);
        Body body = babGen.createBody();
        ByteBuffer chunkBuffer = ByteBuffer.allocate(8192);
        Assert.assertEquals((long)body.read(chunkBuffer), (long)8191L);
        Assert.assertEquals((int)chunkBuffer.position(), (int)8191, (String)"bytes read");
        chunkBuffer.clear();
        Assert.assertEquals((long)body.read(chunkBuffer), (long)-1L, (String)"body at EOF");
    }

    @Test(groups={"standalone"})
    public void testMultipleReads() throws IOException {
        int srcArraySize = 24618;
        byte[] srcArray = new byte[24618];
        this.random.nextBytes(srcArray);
        ByteArrayBodyGenerator babGen = new ByteArrayBodyGenerator(srcArray);
        Body body = babGen.createBody();
        ByteBuffer chunkBuffer = ByteBuffer.allocate(8192);
        int reads = 0;
        int bytesRead = 0;
        while (body.read(chunkBuffer) != -1L) {
            ++reads;
            bytesRead += chunkBuffer.position();
            chunkBuffer.clear();
        }
        Assert.assertEquals((int)reads, (int)4, (String)"reads to drain generator");
        Assert.assertEquals((int)bytesRead, (int)24618, (String)"bytes read");
    }
}

