/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async.grizzly;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.ConnectionPoolTest;
import com.ning.http.client.async.ProviderUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GrizzlyConnectionPoolTest
extends ConnectionPoolTest {
    @Override
    public AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig config) {
        return ProviderUtil.grizzlyProvider(config);
    }

    @Override
    @Test
    public void testMaxTotalConnectionsException() {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setMaxConnections(1).build());){
            String url = this.getTargetUrl();
            ListenableFuture lockRequest = null;
            try {
                lockRequest = client.prepareGet(url).addHeader("LockThread", "true").execute();
            }
            catch (Exception e) {
                Assert.fail((String)"Unexpected exception thrown.", (Throwable)e);
            }
            try {
                client.prepareConnect(url).execute().get();
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                Assert.assertNotNull((Object)cause);
                Assert.assertEquals((String)"Max connections exceeded", (String)cause.getMessage());
            }
            catch (Exception e) {
                Assert.fail((String)"Unexpected exception thrown.", (Throwable)e);
            }
            lockRequest.cancel(true);
        }
    }

    @Override
    @Test
    public void multipleMaxConnectionOpenTest() throws Throwable {
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setConnectTimeout(5000).setMaxConnections(1).build();
        try (AsyncHttpClient c = this.getAsyncHttpClient(cg);){
            String body = "hello there";
            Response response = (Response)c.preparePost(this.getTargetUrl()).setBody(body).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
            Exception exception = null;
            try {
                c.preparePost(String.format("http://127.0.0.1:%d/foo/test", this.port2)).setBody(body).execute().get(30L, TimeUnit.SECONDS);
                Assert.fail((String)"Should throw exception. Too many connections issued.");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                exception = ex;
            }
            Assert.assertNotNull((Object)exception);
        }
    }
}

