/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.generators.FileBodyGenerator;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.listener.TransferListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class TransferListenerTest
extends AbstractBasicTest {
    private static final File TMP = new File(System.getProperty("java.io.tmpdir"), "ahc-tests-" + UUID.randomUUID().toString().substring(0, 8));

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new BasicHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicGetTest() throws Throwable {
        final AtomicReference throwable = new AtomicReference();
        final AtomicReference hSent = new AtomicReference();
        final AtomicReference hRead = new AtomicReference();
        final AtomicReference bb = new AtomicReference();
        final AtomicBoolean completed = new AtomicBoolean(false);
        TransferCompletionHandler tl = new TransferCompletionHandler();
        tl.addTransferListener(new TransferListener(){

            public void onRequestHeadersSent(FluentCaseInsensitiveStringsMap headers) {
                hSent.set(headers);
            }

            public void onResponseHeadersReceived(FluentCaseInsensitiveStringsMap headers) {
                hRead.set(headers);
            }

            public void onBytesReceived(byte[] b) {
                bb.set(b);
            }

            public void onBytesSent(long amount, long current, long total) {
            }

            public void onRequestResponseCompleted() {
                completed.set(true);
            }

            public void onThrowable(Throwable t) {
                throwable.set(t);
            }
        });
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response response = (Response)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)tl).get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertNotNull(hRead.get());
            Assert.assertNotNull(hSent.get());
            Assert.assertNotNull(bb.get());
            Assert.assertNull(throwable.get());
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicPutTest() throws Throwable {
        final AtomicReference throwable = new AtomicReference();
        final AtomicReference hSent = new AtomicReference();
        final AtomicReference hRead = new AtomicReference();
        final AtomicLong bbReceivedLenght = new AtomicLong(0L);
        final AtomicLong bbSentLenght = new AtomicLong(0L);
        final AtomicBoolean completed = new AtomicBoolean(false);
        byte[] bytes = "RatherLargeFileRatherLargeFileRatherLargeFileRatherLargeFile".getBytes("UTF-16");
        long repeats = 1024000 / bytes.length + 1;
        File largeFile = TransferListenerTest.createTempFile(bytes, (int)repeats);
        TransferCompletionHandler tl = new TransferCompletionHandler();
        tl.addTransferListener(new TransferListener(){

            public void onRequestHeadersSent(FluentCaseInsensitiveStringsMap headers) {
                hSent.set(headers);
            }

            public void onResponseHeadersReceived(FluentCaseInsensitiveStringsMap headers) {
                hRead.set(headers);
            }

            public void onBytesReceived(byte[] b) {
                bbReceivedLenght.addAndGet(b.length);
            }

            public void onBytesSent(long amount, long current, long total) {
                bbSentLenght.addAndGet(amount);
            }

            public void onRequestResponseCompleted() {
                completed.set(true);
            }

            public void onThrowable(Throwable t) {
                throwable.set(t);
            }
        });
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response response = (Response)((AsyncHttpClient.BoundRequestBuilder)client.preparePut(this.getTargetUrl()).setBody(largeFile)).execute((AsyncHandler)tl).get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertNotNull(hRead.get());
            Assert.assertNotNull(hSent.get());
            Assert.assertEquals((long)bbReceivedLenght.get(), (long)largeFile.length());
            Assert.assertEquals((long)bbSentLenght.get(), (long)largeFile.length());
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicPutBodyTest() throws Throwable {
        final AtomicReference throwable = new AtomicReference();
        final AtomicReference hSent = new AtomicReference();
        final AtomicReference hRead = new AtomicReference();
        final AtomicLong bbReceivedLenght = new AtomicLong(0L);
        final AtomicLong bbSentLenght = new AtomicLong(0L);
        final AtomicBoolean completed = new AtomicBoolean(false);
        byte[] bytes = "RatherLargeFileRatherLargeFileRatherLargeFileRatherLargeFile".getBytes("UTF-16");
        long repeats = 1024000 / bytes.length + 1;
        File largeFile = TransferListenerTest.createTempFile(bytes, (int)repeats);
        TransferCompletionHandler tl = new TransferCompletionHandler();
        tl.addTransferListener(new TransferListener(){

            public void onRequestHeadersSent(FluentCaseInsensitiveStringsMap headers) {
                hSent.set(headers);
            }

            public void onResponseHeadersReceived(FluentCaseInsensitiveStringsMap headers) {
                hRead.set(headers);
            }

            public void onBytesReceived(byte[] b) {
                bbReceivedLenght.addAndGet(b.length);
            }

            public void onBytesSent(long amount, long current, long total) {
                bbSentLenght.addAndGet(amount);
            }

            public void onRequestResponseCompleted() {
                completed.set(true);
            }

            public void onThrowable(Throwable t) {
                throwable.set(t);
            }
        });
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response response = (Response)((AsyncHttpClient.BoundRequestBuilder)client.preparePut(this.getTargetUrl()).setBody((BodyGenerator)new FileBodyGenerator(largeFile))).execute((AsyncHandler)tl).get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertNotNull(hRead.get());
            Assert.assertNotNull(hSent.get());
            Assert.assertEquals((long)bbReceivedLenght.get(), (long)largeFile.length());
            Assert.assertEquals((long)bbSentLenght.get(), (long)largeFile.length());
        }
    }

    @Override
    public String getTargetUrl() {
        return String.format("http://127.0.0.1:%d/foo/test", this.port1);
    }

    public static File createTempFile(byte[] pattern, int repeat) throws IOException {
        TMP.mkdirs();
        TMP.deleteOnExit();
        File tmpFile = File.createTempFile("tmpfile-", ".data", TMP);
        TransferListenerTest.write(pattern, repeat, tmpFile);
        return tmpFile;
    }

    public static void write(byte[] pattern, int repeat, File file) throws IOException {
        file.deleteOnExit();
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(file);){
            for (int i = 0; i < repeat; ++i) {
                out.write(pattern);
            }
        }
    }

    private class BasicHandler
    extends AbstractHandler {
        private BasicHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            byte[] bytes;
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                httpResponse.addHeader("X-" + param, httpRequest.getHeader(param));
            }
            int size = 10240;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            if ((bytes = new byte[size]).length > 0) {
                httpRequest.getInputStream().read(bytes);
                httpResponse.getOutputStream().write(bytes);
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

