/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.uri.Uri;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class PerRequestRelative302Test
extends AbstractBasicTest {
    private final AtomicBoolean isSet = new AtomicBoolean(false);

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.port1 = this.findFreePort();
        this.port2 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        this.server.setHandler((Handler)new Relative302Handler());
        this.server.start();
        this.log.info("Local HTTP server started successfully");
    }

    @Test(groups={"online", "default_provider"})
    public void redirected302Test() throws Throwable {
        this.isSet.getAndSet(false);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response response = (Response)((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setFollowRedirects(true)).setHeader("X-redirect", "http://www.stackoverflow.com/").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            String anyWebPage = "https://(www.)?stackoverflow.com[^:]*:443";
            String baseUrl = this.getBaseUrl(response.getUri());
            Assert.assertTrue((boolean)baseUrl.matches(anyWebPage), (String)("response baseUrl '" + baseUrl + "' does not show redirection to " + anyWebPage));
        }
    }

    @Test(groups={"online", "default_provider"})
    public void notRedirected302Test() throws Throwable {
        this.isSet.getAndSet(false);
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            Response response = (Response)((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setFollowRedirects(false)).setHeader("X-redirect", "http://www.microsoft.com/").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)302);
        }
    }

    private String getBaseUrl(Uri uri) {
        String url = uri.toString();
        int port = uri.getPort();
        if (port == -1) {
            port = PerRequestRelative302Test.getPort(uri);
            url = url.substring(0, url.length() - 1) + ":" + port;
        }
        return url.substring(0, url.lastIndexOf(":") + String.valueOf(port).length() + 1);
    }

    private static int getPort(Uri uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().equals("http") ? 80 : 443;
        }
        return port;
    }

    @Test(groups={"standalone", "default_provider"})
    public void redirected302InvalidTest() throws Throwable {
        this.isSet.getAndSet(false);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response response = (Response)((AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setFollowRedirects(true)).setHeader("X-redirect", String.format("http://127.0.0.1:%d/", this.port2)).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)404);
        }
        catch (ExecutionException ex) {
            Assert.assertEquals(ex.getCause().getClass(), ConnectException.class);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void relativeLocationUrl() throws Throwable {
        this.isSet.getAndSet(false);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response response = (Response)((AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setFollowRedirects(true)).setHeader("X-redirect", "/foo/test").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getUri().toString(), (String)this.getTargetUrl());
        }
    }

    private class Relative302Handler
    extends HandlerWrapper {
        private Relative302Handler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            httpResponse.setContentType("text/html; charset=utf-8");
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                if (!param.startsWith("X-redirect") || PerRequestRelative302Test.this.isSet.getAndSet(true)) continue;
                httpResponse.addHeader("Location", httpRequest.getHeader(param));
                httpResponse.setStatus(302);
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
                return;
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

