/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class MultipleHeaderTest
extends AbstractBasicTest {
    private ExecutorService executorService;
    private ServerSocket serverSocket;
    private Future<?> voidFuture;

    @Test(groups={"standalone", "default_provider"})
    public void testMultipleOtherHeaders() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        final String[] xffHeaders = new String[]{null, null};
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Request req = new RequestBuilder("GET").setUrl("http://localhost:" + this.port1 + "/MultiOther").build();
            final CountDownLatch latch = new CountDownLatch(1);
            client.executeRequest(req, (AsyncHandler)new AsyncHandler<Void>(){

                public void onThrowable(Throwable t) {
                    t.printStackTrace(System.out);
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart objectHttpResponseBodyPart) throws Exception {
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus objectHttpResponseStatus) throws Exception {
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders response) throws Exception {
                    int i = 0;
                    for (String header : response.getHeaders().get((Object)"X-Forwarded-For")) {
                        xffHeaders[i++] = header;
                    }
                    latch.countDown();
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Void onCompleted() throws Exception {
                    return null;
                }
            }).get(3L, TimeUnit.SECONDS);
            if (!latch.await(2L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Time out");
            }
            Assert.assertNotNull((Object)xffHeaders[0]);
            Assert.assertNotNull((Object)xffHeaders[1]);
            try {
                Assert.assertEquals((String)xffHeaders[0], (String)"abc");
                Assert.assertEquals((String)xffHeaders[1], (String)"def");
            }
            catch (AssertionError ex) {
                Assert.assertEquals((String)xffHeaders[1], (String)"abc");
                Assert.assertEquals((String)xffHeaders[0], (String)"def");
            }
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testMultipleEntityHeaders() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        final String[] clHeaders = new String[]{null, null};
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Request req = new RequestBuilder("GET").setUrl("http://localhost:" + this.port1 + "/MultiEnt").build();
            final CountDownLatch latch = new CountDownLatch(1);
            client.executeRequest(req, (AsyncHandler)new AsyncHandler<Void>(){

                public void onThrowable(Throwable t) {
                    t.printStackTrace(System.out);
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart objectHttpResponseBodyPart) throws Exception {
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus objectHttpResponseStatus) throws Exception {
                    return AsyncHandler.STATE.CONTINUE;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders response) throws Exception {
                    try {
                        int i = 0;
                        for (String header : response.getHeaders().get((Object)"Content-Length")) {
                            clHeaders[i++] = header;
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Void onCompleted() throws Exception {
                    return null;
                }
            }).get(3L, TimeUnit.SECONDS);
            if (!latch.await(2L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Time out");
            }
            Assert.assertNotNull((Object)clHeaders[0]);
            Assert.assertNotNull((Object)clHeaders[1]);
            try {
                Assert.assertEquals((String)clHeaders[0], (String)"2");
                Assert.assertEquals((String)clHeaders[1], (String)"1");
            }
            catch (Throwable ex) {
                Assert.assertEquals((String)clHeaders[0], (String)"1");
                Assert.assertEquals((String)clHeaders[1], (String)"2");
            }
        }
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.port1 = this.findFreePort();
        this.serverSocket = new ServerSocket(this.port1);
        this.executorService = Executors.newFixedThreadPool(1);
        this.voidFuture = this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Socket socket;
                while ((socket = MultipleHeaderTest.this.serverSocket.accept()) != null) {
                    OutputStreamWriter outputStreamWriter;
                    InputStream inputStream = socket.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    String req = reader.readLine().split(" ")[1];
                    int i = inputStream.available();
                    long l = inputStream.skip(i);
                    Assert.assertEquals((long)l, (long)i);
                    socket.shutdownInput();
                    if (req.endsWith("MultiEnt")) {
                        outputStreamWriter = new OutputStreamWriter(socket.getOutputStream());
                        outputStreamWriter.append("HTTP/1.0 200 OK\nConnection: close\nContent-Type: text/plain; charset=iso-8859-1\nContent-Length: 2\nContent-Length: 1\n\n0\n");
                        outputStreamWriter.flush();
                        socket.shutdownOutput();
                        continue;
                    }
                    if (!req.endsWith("MultiOther")) continue;
                    outputStreamWriter = new OutputStreamWriter(socket.getOutputStream());
                    outputStreamWriter.append("HTTP/1.0 200 OK\nConnection: close\nContent-Type: text/plain; charset=iso-8859-1\nContent-Length: 1\nX-Forwarded-For: abc\nX-Forwarded-For: def\n\n0\n");
                    outputStreamWriter.flush();
                    socket.shutdownOutput();
                }
                return null;
            }
        });
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.voidFuture.cancel(true);
        this.executorService.shutdownNow();
        this.serverSocket.close();
    }
}

