/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class MaxConnectionsInThreads
extends AbstractBasicTest {
    private static URI servletEndpointUri;

    @Test(groups={"online", "default_provider"})
    public void testMaxConnectionsWithinThreads() throws InterruptedException {
        String[] urls = new String[]{servletEndpointUri.toString(), servletEndpointUri.toString()};
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setConnectTimeout(1000).setRequestTimeout(5000).setAllowPoolingConnections(true).setMaxConnections(1).setMaxConnectionsPerHost(1).build();
        final CountDownLatch inThreadsLatch = new CountDownLatch(2);
        final AtomicInteger failedCount = new AtomicInteger();
        try (final AsyncHttpClient client = this.getAsyncHttpClient(config);){
            for (int i = 0; i < urls.length; ++i) {
                final String url = urls[i];
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        client.prepareGet(url).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                            public Response onCompleted(Response response) throws Exception {
                                Response r = super.onCompleted(response);
                                inThreadsLatch.countDown();
                                return r;
                            }

                            public void onThrowable(Throwable t) {
                                super.onThrowable(t);
                                failedCount.incrementAndGet();
                                inThreadsLatch.countDown();
                            }
                        });
                    }
                };
                t.start();
            }
            inThreadsLatch.await();
            Assert.assertEquals((int)failedCount.get(), (int)1, (String)"Max Connections should have been reached when launching from concurrent threads");
            final CountDownLatch notInThreadsLatch = new CountDownLatch(2);
            failedCount.set(0);
            int i = 0;
            while (i < urls.length) {
                String url = urls[i];
                final int rank = i++;
                client.prepareGet(url).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                    public Response onCompleted(Response response) throws Exception {
                        Response r = super.onCompleted(response);
                        notInThreadsLatch.countDown();
                        return r;
                    }

                    public void onThrowable(Throwable t) {
                        super.onThrowable(t);
                        failedCount.set(rank);
                        notInThreadsLatch.countDown();
                    }
                });
            }
            notInThreadsLatch.await();
            Assert.assertEquals((int)failedCount.get(), (int)1, (String)"Max Connections should have been reached when launching from main thread");
        }
    }

    @Override
    @BeforeClass
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.port1 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new MockTimeoutHttpServlet()), "/timeout/*");
        this.server.start();
        String endpoint = "http://127.0.0.1:" + this.port1 + "/timeout/";
        servletEndpointUri = new URI(endpoint);
    }

    @Override
    public String getTargetUrl() {
        String s = "http://127.0.0.1:" + this.port1 + "/timeout/";
        try {
            servletEndpointUri = new URI(s);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static class MockTimeoutHttpServlet
    extends HttpServlet {
        private static final String contentType = "text/plain";
        public static long DEFAULT_TIMEOUT = 2000L;

        public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            res.setStatus(200);
            res.addHeader("Content-Type", contentType);
            long sleepTime = DEFAULT_TIMEOUT;
            try {
                sleepTime = Integer.parseInt(req.getParameter("timeout"));
            }
            catch (NumberFormatException e) {
                sleepTime = DEFAULT_TIMEOUT;
            }
            try {
                System.out.println("=======================================");
                System.out.println("Servlet is sleeping for: " + sleepTime);
                System.out.println("=======================================");
                System.out.flush();
                Thread.sleep(sleepTime);
                System.out.println("=======================================");
                System.out.println("Servlet is awake for");
                System.out.println("=======================================");
                System.out.flush();
            }
            catch (Exception e) {
                // empty catch block
            }
            res.setHeader("XXX", "TripleX");
            byte[] retVal = "1".getBytes();
            try (ServletOutputStream os = res.getOutputStream();){
                res.setContentLength(retVal.length);
                os.write(retVal);
            }
        }
    }
}

