/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class HostnameVerifierTest
extends AbstractBasicTest {
    protected final Logger log = LoggerFactory.getLogger(HostnameVerifierTest.class);
    private static final AtomicBoolean TRUST_SERVER_CERT = new AtomicBoolean(true);
    private static final TrustManager DUMMY_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (!TRUST_SERVER_CERT.get()) {
                throw new CertificateException("Server certificate not trusted.");
            }
        }
    };

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.server.stop();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDownProps() throws Exception {
        System.clearProperty("javax.net.ssl.keyStore");
        System.clearProperty("javax.net.ssl.trustStore");
    }

    @Override
    protected String getTargetUrl() {
        return String.format("https://127.0.0.1:%d/foo/test", this.port1);
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new EchoHandler();
    }

    @Override
    protected int findFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.port1 = this.findFreePort();
        HttpConfiguration https_config = new HttpConfiguration();
        https_config.setSecureScheme("https");
        https_config.setSecurePort(this.port1);
        https_config.setOutputBufferSize(32768);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(2000L);
        src.setStsIncludeSubDomains(true);
        https_config.addCustomizer((HttpConfiguration.Customizer)src);
        SslContextFactory sslContextFactory = new SslContextFactory();
        ClassLoader cl = this.getClass().getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        String trustStoreFile = new File(cacertsUrl.toURI()).getAbsolutePath();
        sslContextFactory.setTrustStorePath(trustStoreFile);
        sslContextFactory.setTrustStorePassword("changeit");
        sslContextFactory.setTrustStoreType("JKS");
        this.log.info("SSL certs path: {}", (Object)trustStoreFile);
        URL keystoreUrl = cl.getResource("ssltest-keystore.jks");
        String keyStoreFile = new File(keystoreUrl.toURI()).getAbsolutePath();
        sslContextFactory.setKeyStorePath(keyStoreFile);
        sslContextFactory.setKeyStorePassword("changeit");
        sslContextFactory.setKeyStoreType("JKS");
        this.log.info("SSL keystore path: {}", (Object)keyStoreFile);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        connector.setHost("127.0.0.1");
        connector.setPort(this.port1);
        this.server.addConnector((Connector)connector);
        this.server.setHandler((Handler)this.configureHandler());
        this.server.start();
        this.log.info("Local HTTP server started successfully");
    }

    @Test(groups={"standalone", "default_provider"})
    public void positiveHostnameVerifierTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setHostnameVerifier((HostnameVerifier)new PositiveHostVerifier()).setSSLContext(HostnameVerifierTest.createSSLContext()).build());){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            ListenableFuture f = ((AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(file)).setHeader("Content-Type", "text/html").execute();
            Response resp = (Response)f.get();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getResponseBody(), (String)"This is a simple test file");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void negativeHostnameVerifierTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setHostnameVerifier((HostnameVerifier)new NegativeHostVerifier()).setSSLContext(HostnameVerifierTest.createSSLContext()).build());){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            try {
                ((AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(file)).setHeader("Content-Type", "text/html").execute().get();
            }
            catch (ExecutionException ex) {
                Assert.assertTrue((boolean)(ex.getCause() instanceof ConnectException));
            }
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void remoteIDHostnameVerifierTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setHostnameVerifier((HostnameVerifier)new CheckHost("bouette")).setSSLContext(HostnameVerifierTest.createSSLContext()).build());){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            try {
                ((AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(file)).setHeader("Content-Type", "text/html").execute().get();
            }
            catch (ExecutionException ex) {
                Assert.assertTrue((boolean)(ex.getCause() instanceof ConnectException));
            }
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void remotePosHostnameVerifierTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setHostnameVerifier((HostnameVerifier)new CheckHost("localhost")).setSSLContext(HostnameVerifierTest.createSSLContext()).build());){
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource("SimpleTextFile.txt");
            File file = new File(url.toURI());
            try {
                ((AsyncHttpClient.BoundRequestBuilder)client.preparePost(this.getTargetUrl()).setBody(file)).setHeader("Content-Type", "text/html").execute().get();
            }
            catch (ExecutionException ex) {
                Assert.assertTrue((boolean)(ex.getCause() instanceof ConnectException));
            }
        }
    }

    private static SSLContext createSSLContext() {
        try {
            InputStream keyStoreStream = HostnameVerifierTest.class.getResourceAsStream("ssltest-cacerts.jks");
            char[] keyStorePassword = "changeit".toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(keyStoreStream, keyStorePassword);
            char[] certificatePassword = "changeit".toCharArray();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, certificatePassword);
            KeyManager[] keyManagers = kmf.getKeyManagers();
            TrustManager[] trustManagers = new TrustManager[]{DUMMY_TRUST_MANAGER};
            SecureRandom secureRandom = new SecureRandom();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, secureRandom);
            return sslContext;
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the server-side SSLContext", e);
        }
    }

    public static class CheckHost
    implements HostnameVerifier {
        private final String hostName;

        public CheckHost(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return s != null && s.equalsIgnoreCase(this.hostName);
        }
    }

    public static class NegativeHostVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    public static class PositiveHostVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    public static class EchoHandler
    extends HandlerWrapper {
        public void handle(String pathInContext, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
            String queryString;
            String param;
            httpResponse.setContentType("text/html; charset=utf-8");
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                param = e.nextElement().toString();
                if (param.startsWith("LockThread")) {
                    try {
                        Thread.sleep(40000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                httpResponse.addHeader("X-" + param, httpRequest.getHeader(param));
            }
            Enumeration i = httpRequest.getParameterNames();
            StringBuilder requestBody = new StringBuilder();
            while (i.hasMoreElements()) {
                param = i.nextElement().toString();
                httpResponse.addHeader("X-" + param, httpRequest.getParameter(param));
                requestBody.append(param);
                requestBody.append("_");
            }
            String pathInfo = httpRequest.getPathInfo();
            if (pathInfo != null) {
                httpResponse.addHeader("X-pathInfo", pathInfo);
            }
            if ((queryString = httpRequest.getQueryString()) != null) {
                httpResponse.addHeader("X-queryString", queryString);
            }
            httpResponse.addHeader("X-KEEP-ALIVE", httpRequest.getRemoteAddr() + ":" + httpRequest.getRemotePort());
            Cookie[] cs = httpRequest.getCookies();
            if (cs != null) {
                for (Cookie c : cs) {
                    httpResponse.addCookie(c);
                }
            }
            if (requestBody.length() > 0) {
                httpResponse.getOutputStream().write(requestBody.toString().getBytes());
            }
            int size = 10240;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            byte[] bytes = new byte[size];
            int pos = 0;
            if (bytes.length > 0) {
                int read = 0;
                while (read != -1) {
                    read = httpRequest.getInputStream().read(bytes, pos, bytes.length - pos);
                    pos += read;
                }
                httpResponse.getOutputStream().write(bytes);
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

