/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.extra.ThrottleRequestFilter;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.filter.ResponseFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class FilterTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new BasicHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicTest() throws Throwable {
        AsyncHttpClientConfig.Builder b = new AsyncHttpClientConfig.Builder();
        b.addRequestFilter((RequestFilter)new ThrottleRequestFilter(100));
        try (AsyncHttpClient client = this.getAsyncHttpClient(b.build());){
            Response response = (Response)client.preparePost(this.getTargetUrl()).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void loadThrottleTest() throws Throwable {
        AsyncHttpClientConfig.Builder b = new AsyncHttpClientConfig.Builder();
        b.addRequestFilter((RequestFilter)new ThrottleRequestFilter(10));
        try (AsyncHttpClient client = this.getAsyncHttpClient(b.build());){
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (int i = 0; i < 200; ++i) {
                futures.add(client.preparePost(this.getTargetUrl()).execute());
            }
            for (Future future : futures) {
                Response r = (Response)future.get();
                Assert.assertNotNull(future.get());
                Assert.assertEquals((int)r.getStatusCode(), (int)200);
            }
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void maxConnectionsText() throws Throwable {
        AsyncHttpClientConfig.Builder b = new AsyncHttpClientConfig.Builder();
        b.addRequestFilter((RequestFilter)new ThrottleRequestFilter(0, 1000));
        try (AsyncHttpClient client = this.getAsyncHttpClient(b.build());){
            client.preparePost(this.getTargetUrl()).execute().get();
            Assert.fail((String)"Should have timed out");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof FilterException));
        }
    }

    @Override
    public String getTargetUrl() {
        return String.format("http://127.0.0.1:%d/foo/test", this.port1);
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicResponseFilterTest() throws Throwable {
        AsyncHttpClientConfig.Builder b = new AsyncHttpClientConfig.Builder();
        b.addResponseFilter(new ResponseFilter(){

            public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                return ctx;
            }
        });
        try (AsyncHttpClient client = this.getAsyncHttpClient(b.build());){
            Response response = (Response)client.preparePost(this.getTargetUrl()).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void replayResponseFilterTest() throws Throwable {
        AsyncHttpClientConfig.Builder b = new AsyncHttpClientConfig.Builder();
        final AtomicBoolean replay = new AtomicBoolean(true);
        b.addResponseFilter(new ResponseFilter(){

            public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                if (replay.getAndSet(false)) {
                    Request request = new RequestBuilder(ctx.getRequest()).addHeader("X-Replay", "true").build();
                    return new FilterContext.FilterContextBuilder().asyncHandler(ctx.getAsyncHandler()).request(request).replayRequest(true).build();
                }
                return ctx;
            }
        });
        try (AsyncHttpClient c = this.getAsyncHttpClient(b.build());){
            Response response = (Response)c.preparePost(this.getTargetUrl()).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("X-Replay"), (String)"true");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void replayStatusCodeResponseFilterTest() throws Throwable {
        AsyncHttpClientConfig.Builder b = new AsyncHttpClientConfig.Builder();
        final AtomicBoolean replay = new AtomicBoolean(true);
        b.addResponseFilter(new ResponseFilter(){

            public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                if (ctx.getResponseStatus() != null && ctx.getResponseStatus().getStatusCode() == 200 && replay.getAndSet(false)) {
                    Request request = new RequestBuilder(ctx.getRequest()).addHeader("X-Replay", "true").build();
                    return new FilterContext.FilterContextBuilder().asyncHandler(ctx.getAsyncHandler()).request(request).replayRequest(true).build();
                }
                return ctx;
            }
        });
        try (AsyncHttpClient c = this.getAsyncHttpClient(b.build());){
            Response response = (Response)c.preparePost(this.getTargetUrl()).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("X-Replay"), (String)"true");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void replayHeaderResponseFilterTest() throws Throwable {
        AsyncHttpClientConfig.Builder b = new AsyncHttpClientConfig.Builder();
        final AtomicBoolean replay = new AtomicBoolean(true);
        b.addResponseFilter(new ResponseFilter(){

            public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
                if (ctx.getResponseHeaders() != null && ctx.getResponseHeaders().getHeaders().getFirstValue("Ping").equals("Pong") && replay.getAndSet(false)) {
                    Request request = new RequestBuilder(ctx.getRequest()).addHeader("Ping", "Pong").build();
                    return new FilterContext.FilterContextBuilder().asyncHandler(ctx.getAsyncHandler()).request(request).replayRequest(true).build();
                }
                return ctx;
            }
        });
        try (AsyncHttpClient c = this.getAsyncHttpClient(b.build());){
            Response response = (Response)c.preparePost(this.getTargetUrl()).addHeader("Ping", "Pong").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getHeader("Ping"), (String)"Pong");
        }
    }

    private class BasicHandler
    extends AbstractHandler {
        private BasicHandler() {
        }

        public void handle(String s, org.eclipse.jetty.server.Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                httpResponse.addHeader(param, httpRequest.getHeader(param));
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

