/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class ByteBufferCapacityTest
extends AbstractBasicTest {
    private static final File TMP = new File(System.getProperty("java.io.tmpdir"), "ahc-tests-" + UUID.randomUUID().toString().substring(0, 8));

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new BasicHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void basicByteBufferTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            byte[] bytes = "RatherLargeFileRatherLargeFileRatherLargeFileRatherLargeFile".getBytes("UTF-16");
            long repeats = 1024000 / bytes.length + 1;
            File largeFile = ByteBufferCapacityTest.createTempFile(bytes, (int)repeats);
            final AtomicInteger byteReceived = new AtomicInteger();
            try {
                Response response = (Response)((AsyncHttpClient.BoundRequestBuilder)client.preparePut(this.getTargetUrl()).setBody(largeFile)).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                        byteReceived.addAndGet(content.getBodyByteBuffer().capacity());
                        return super.onBodyPartReceived(content);
                    }
                }).get();
                Assert.assertNotNull((Object)response);
                Assert.assertEquals((int)response.getStatusCode(), (int)200);
                Assert.assertEquals((long)byteReceived.get(), (long)largeFile.length());
                Assert.assertEquals((long)response.getResponseBody().length(), (long)largeFile.length());
            }
            catch (IOException ex) {
                Assert.fail((String)"Should have timed out");
            }
        }
    }

    @Override
    public String getTargetUrl() {
        return String.format("http://127.0.0.1:%d/foo/test", this.port1);
    }

    public static File createTempFile(byte[] pattern, int repeat) throws IOException {
        TMP.mkdirs();
        TMP.deleteOnExit();
        File tmpFile = File.createTempFile("tmpfile-", ".data", TMP);
        ByteBufferCapacityTest.write(pattern, repeat, tmpFile);
        return tmpFile;
    }

    public static void write(byte[] pattern, int repeat, File file) throws IOException {
        file.deleteOnExit();
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(file);){
            for (int i = 0; i < repeat; ++i) {
                out.write(pattern);
            }
        }
    }

    private class BasicHandler
    extends HandlerWrapper {
        private BasicHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            byte[] bytes;
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                httpResponse.addHeader("X-" + param, httpRequest.getHeader(param));
            }
            int size = 10240;
            if (httpRequest.getContentLength() > 0) {
                size = httpRequest.getContentLength();
            }
            if ((bytes = new byte[size]).length > 0) {
                int read;
                ServletInputStream in = httpRequest.getInputStream();
                ServletOutputStream out = httpResponse.getOutputStream();
                while ((read = in.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

