/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.uri;

import com.ning.http.client.uri.Uri;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UriTest {
    @Test
    public void testSimpleParsing() {
        Uri url = Uri.create((String)"https://graph.facebook.com/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"graph.facebook.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/750198471659552/accounts/test-users");
        Assert.assertEquals((String)url.getQuery(), (String)"method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRootRelativeURIWithRootContext() {
        Uri context = Uri.create((String)"https://graph.facebook.com");
        Uri url = Uri.create((Uri)context, (String)"/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"graph.facebook.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/750198471659552/accounts/test-users");
        Assert.assertEquals((String)url.getQuery(), (String)"method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRootRelativeURIWithNonRootContext() {
        Uri context = Uri.create((String)"https://graph.facebook.com/foo/bar");
        Uri url = Uri.create((Uri)context, (String)"/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"graph.facebook.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/750198471659552/accounts/test-users");
        Assert.assertEquals((String)url.getQuery(), (String)"method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testNonRootRelativeURIWithNonRootContext() {
        Uri context = Uri.create((String)"https://graph.facebook.com/foo/bar");
        Uri url = Uri.create((Uri)context, (String)"750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"graph.facebook.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/foo/750198471659552/accounts/test-users");
        Assert.assertEquals((String)url.getQuery(), (String)"method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testAbsoluteURIWithContext() {
        Uri context = Uri.create((String)"https://hello.com/foo/bar");
        Uri url = Uri.create((Uri)context, (String)"https://graph.facebook.com/750198471659552/accounts/test-users?method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"graph.facebook.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/750198471659552/accounts/test-users");
        Assert.assertEquals((String)url.getQuery(), (String)"method=get&access_token=750198471659552lleveCvbUu_zqBa9tkT3tcgaPh4");
    }

    @Test
    public void testRelativeUriWithDots() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2/");
        Uri url = Uri.create((Uri)context, (String)"../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/level1/other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithDotsAboveRoot() {
        Uri context = Uri.create((String)"https://hello.com/level1");
        Uri url = Uri.create((Uri)context, (String)"../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithAbsoluteDots() {
        Uri context = Uri.create((String)"https://hello.com/level1/");
        Uri url = Uri.create((Uri)context, (String)"/../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDots() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2/");
        Uri url = Uri.create((Uri)context, (String)"../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsAboveRoot() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2");
        Uri url = Uri.create((Uri)context, (String)"../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithAbsoluteConsecutiveDots() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2/");
        Uri url = Uri.create((Uri)context, (String)"/../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromRoot() {
        Uri context = Uri.create((String)"https://hello.com/");
        Uri url = Uri.create((Uri)context, (String)"../../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../../../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromRootResource() {
        Uri context = Uri.create((String)"https://hello.com/level1");
        Uri url = Uri.create((Uri)context, (String)"../../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../../../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromSubrootResource() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2");
        Uri url = Uri.create((Uri)context, (String)"../../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }

    @Test
    public void testRelativeUriWithConsecutiveDotsFromLevel3Resource() {
        Uri context = Uri.create((String)"https://hello.com/level1/level2/level3");
        Uri url = Uri.create((Uri)context, (String)"../../../other/content/img.png");
        Assert.assertEquals((String)url.getScheme(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"hello.com");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/../other/content/img.png");
        Assert.assertNull((Object)url.getQuery());
    }
}

