/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.uri.Uri;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class Relative302Test
extends AbstractBasicTest {
    private final AtomicBoolean isSet = new AtomicBoolean(false);

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.port1 = this.findFreePort();
        this.port2 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        this.server.setHandler((Handler)new Relative302Handler());
        this.server.start();
        this.log.info("Local HTTP server started successfully");
    }

    @Test(groups={"online", "default_provider"})
    public void redirected302Test() throws Throwable {
        this.isSet.getAndSet(false);
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            Response response = (Response)client.prepareGet(this.getTargetUrl()).setHeader("X-redirect", "http://www.google.com/").execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            String baseUrl = this.getBaseUrl(response.getUri());
            Assert.assertTrue((boolean)baseUrl.startsWith("http://www.google."), (String)("response does not show redirection to a google subdomain, got " + baseUrl));
        }
    }

    private String getBaseUrl(Uri uri) {
        String url = uri.toString();
        int port = uri.getPort();
        if (port == -1) {
            port = Relative302Test.getPort(uri);
            url = url.substring(0, url.length() - 1) + ":" + port;
        }
        return url.substring(0, url.lastIndexOf(":") + String.valueOf(port).length() + 1);
    }

    private static int getPort(Uri uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().equals("http") ? 80 : 443;
        }
        return port;
    }

    @Test(groups={"standalone", "default_provider"})
    public void redirected302InvalidTest() throws Throwable {
        this.isSet.getAndSet(false);
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            Response response = (Response)client.prepareGet(this.getTargetUrl()).setHeader("X-redirect", String.format("http://127.0.0.1:%d/", this.port2)).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)404);
        }
        catch (ExecutionException ex) {
            Assert.assertEquals(ex.getCause().getClass(), ConnectException.class);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void absolutePathRedirectTest() throws Throwable {
        this.isSet.getAndSet(false);
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            String redirectTarget = "/bar/test";
            String destinationUrl = new URI(this.getTargetUrl()).resolve(redirectTarget).toString();
            Response response = (Response)client.prepareGet(this.getTargetUrl()).setHeader("X-redirect", redirectTarget).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getUri().toString(), (String)destinationUrl);
            this.log.debug("{} was redirected to {}", (Object)redirectTarget, (Object)destinationUrl);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void relativePathRedirectTest() throws Throwable {
        this.isSet.getAndSet(false);
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            String redirectTarget = "bar/test1";
            String destinationUrl = new URI(this.getTargetUrl()).resolve(redirectTarget).toString();
            Response response = (Response)client.prepareGet(this.getTargetUrl()).setHeader("X-redirect", redirectTarget).execute().get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getUri().toString(), (String)destinationUrl);
            this.log.debug("{} was redirected to {}", (Object)redirectTarget, (Object)destinationUrl);
        }
    }

    private class Relative302Handler
    extends AbstractHandler {
        private Relative302Handler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            httpResponse.setStatus(200);
            httpResponse.setContentType("text/html; charset=utf-8");
            Enumeration e = httpRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String param = e.nextElement().toString();
                if (!param.startsWith("X-redirect") || Relative302Test.this.isSet.getAndSet(true)) continue;
                httpResponse.addHeader("Location", httpRequest.getHeader(param));
                httpResponse.setStatus(302);
                break;
            }
            httpResponse.setContentLength(0);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

