/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FluentCaseInsensitiveStringsMapTest {
    @Test
    public void emptyTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        Assert.assertTrue((boolean)map.keySet().isEmpty());
    }

    @Test
    public void normalTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void nameCaseTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("fOO", "bAr");
        map.add("Baz", Arrays.asList("fOo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("fOO", "Baz")));
        Assert.assertEquals((String)map.getFirstValue("fOO"), (String)"bAr");
        Assert.assertEquals((String)map.getJoinedValue("fOO", ", "), (String)"bAr");
        Assert.assertEquals((Collection)map.get((Object)"fOO"), Arrays.asList("bAr"));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bAr");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bAr");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bAr"));
        Assert.assertEquals((String)map.getFirstValue("FOO"), (String)"bAr");
        Assert.assertEquals((String)map.getJoinedValue("FOO", ", "), (String)"bAr");
        Assert.assertEquals((Collection)map.get((Object)"FOO"), Arrays.asList("bAr"));
        Assert.assertEquals((String)map.getFirstValue("Baz"), (String)"fOo");
        Assert.assertEquals((String)map.getJoinedValue("Baz", ", "), (String)"fOo, bar");
        Assert.assertEquals((Collection)map.get((Object)"Baz"), Arrays.asList("fOo", "bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"fOo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"fOo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("fOo", "bar"));
        Assert.assertEquals((String)map.getFirstValue("BAZ"), (String)"fOo");
        Assert.assertEquals((String)map.getJoinedValue("BAZ", ", "), (String)"fOo, bar");
        Assert.assertEquals((Collection)map.get((Object)"BAZ"), Arrays.asList("fOo", "bar"));
    }

    @Test
    public void sameKeyMultipleTimesTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "baz,foo");
        map.add("Foo", Arrays.asList("bar"));
        map.add("fOO", new String[]{"bla", "blubb"});
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"baz,foo");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"baz,foo, bar, bla, blubb");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("baz,foo", "bar", "bla", "blubb"));
        Assert.assertEquals((String)map.getFirstValue("Foo"), (String)"baz,foo");
        Assert.assertEquals((String)map.getJoinedValue("Foo", ", "), (String)"baz,foo, bar, bla, blubb");
        Assert.assertEquals((Collection)map.get((Object)"Foo"), Arrays.asList("baz,foo", "bar", "bla", "blubb"));
        Assert.assertEquals((String)map.getFirstValue("fOO"), (String)"baz,foo");
        Assert.assertEquals((String)map.getJoinedValue("fOO", ", "), (String)"baz,foo, bar, bla, blubb");
        Assert.assertEquals((Collection)map.get((Object)"fOO"), Arrays.asList("baz,foo", "bar", "bla", "blubb"));
    }

    @Test
    public void emptyValueTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "");
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList(""));
    }

    @Test
    public void nullValueTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", (String)null);
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"");
        Assert.assertEquals((int)map.get((Object)"foo").size(), (int)1);
    }

    @Test
    public void mapConstructorTest() {
        LinkedHashMap<String, List<String>> headerMap = new LinkedHashMap<String, List<String>>();
        headerMap.put("foo", Arrays.asList("baz,foo"));
        headerMap.put("baz", Arrays.asList("bar"));
        headerMap.put("bar", Arrays.asList("bla", "blubb"));
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap(headerMap);
        headerMap.remove("foo");
        headerMap.remove("bar");
        headerMap.remove("baz");
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz", "bar")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"baz,foo");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"baz,foo");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("baz,foo"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"bla");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"bla, blubb");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("bla", "blubb"));
    }

    @Test
    public void mapConstructorNullTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap((Map)null);
        Assert.assertEquals((int)map.keySet().size(), (int)0);
    }

    @Test
    public void copyConstructorTest() {
        FluentCaseInsensitiveStringsMap srcHeaders = new FluentCaseInsensitiveStringsMap();
        srcHeaders.add("foo", "baz,foo");
        srcHeaders.add("baz", Arrays.asList("bar"));
        srcHeaders.add("bar", new String[]{"bla", "blubb"});
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap(srcHeaders);
        srcHeaders.delete("foo");
        srcHeaders.delete("bar");
        srcHeaders.delete("baz");
        Assert.assertTrue((boolean)srcHeaders.keySet().isEmpty());
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz", "bar")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"baz,foo");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"baz,foo");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("baz,foo"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"bla");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"bla, blubb");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("bla", "blubb"));
    }

    @Test
    public void copyConstructorNullTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap((FluentCaseInsensitiveStringsMap)null);
        Assert.assertEquals((int)map.keySet().size(), (int)0);
    }

    @Test
    public void deleteTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.delete("bAz");
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertNull((Object)map.getFirstValue("baz"));
        Assert.assertNull((Object)map.getJoinedValue("baz", ", "));
        Assert.assertTrue((boolean)map.get((Object)"baz").isEmpty());
    }

    @Test
    public void deleteUndefinedKeyTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.delete("bar");
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void deleteNullTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.delete(null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void deleteAllArrayTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.deleteAll(new String[]{"bAz", "Boo"});
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertNull((Object)map.getFirstValue("baz"));
        Assert.assertNull((Object)map.getJoinedValue("baz", ", "));
        Assert.assertTrue((boolean)map.get((Object)"baz").isEmpty());
    }

    @Test
    public void deleteAllCollectionTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.deleteAll(Arrays.asList("bAz", "fOO"));
        Assert.assertEquals((Collection)map.keySet(), Collections.emptyList());
        Assert.assertNull((Object)map.getFirstValue("foo"));
        Assert.assertNull((Object)map.getJoinedValue("foo", ", "));
        Assert.assertTrue((boolean)map.get((Object)"foo").isEmpty());
        Assert.assertNull((Object)map.getFirstValue("baz"));
        Assert.assertNull((Object)map.getJoinedValue("baz", ", "));
        Assert.assertTrue((boolean)map.get((Object)"baz").isEmpty());
    }

    @Test
    public void deleteAllNullArrayTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.deleteAll((String[])null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void deleteAllNullCollectionTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.deleteAll((Collection)null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceWith("Foo", new String[]{"blub", "bla"});
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("Foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"blub");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"blub, bla");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("blub", "bla"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceUndefinedTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceWith("bar", Arrays.asList("blub"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz", "bar")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"blub");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"blub");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("blub"));
    }

    @Test
    public void replaceNullTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceWith(null, Arrays.asList("blub"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceValueWithNullTest() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceWith("baZ", (Collection)null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertNull((Object)map.getFirstValue("baz"));
        Assert.assertNull((Object)map.getJoinedValue("baz", ", "));
        Assert.assertTrue((boolean)map.get((Object)"baz").isEmpty());
    }

    @Test
    public void replaceAllMapTest1() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("bar", new String[]{"foo, bar", "baz"});
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceAll(new FluentCaseInsensitiveStringsMap().add("Bar", "baz").add("Boo", new String[]{"blub", "bla"}));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "Bar", "baz", "Boo")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"baz");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        Assert.assertEquals((String)map.getFirstValue("Boo"), (String)"blub");
        Assert.assertEquals((String)map.getJoinedValue("Boo", ", "), (String)"blub, bla");
        Assert.assertEquals((Collection)map.get((Object)"Boo"), Arrays.asList("blub", "bla"));
    }

    @Test
    public void replaceAllTest2() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("bar", new String[]{"foo, bar", "baz"});
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        LinkedHashMap<String, List<String>> newValues = new LinkedHashMap<String, List<String>>();
        newValues.put("Bar", Arrays.asList("baz"));
        newValues.put("Foo", null);
        map.replaceAll(newValues);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("Bar", "baz")));
        Assert.assertNull((Object)map.getFirstValue("foo"));
        Assert.assertNull((Object)map.getJoinedValue("foo", ", "));
        Assert.assertTrue((boolean)map.get((Object)"foo").isEmpty());
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"baz");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceAllNullTest1() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("bar", new String[]{"foo, bar", "baz"});
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceAll((FluentCaseInsensitiveStringsMap)null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }

    @Test
    public void replaceAllNullTest2() {
        FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap();
        map.add("foo", "bar");
        map.add("bar", new String[]{"foo, bar", "baz"});
        map.add("baz", Arrays.asList("foo", "bar"));
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
        map.replaceAll((Map)null);
        Assert.assertEquals((Set)map.keySet(), new LinkedHashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((String)map.getFirstValue("foo"), (String)"bar");
        Assert.assertEquals((String)map.getJoinedValue("foo", ", "), (String)"bar");
        Assert.assertEquals((Collection)map.get((Object)"foo"), Arrays.asList("bar"));
        Assert.assertEquals((String)map.getFirstValue("bar"), (String)"foo, bar");
        Assert.assertEquals((String)map.getJoinedValue("bar", ", "), (String)"foo, bar, baz");
        Assert.assertEquals((Collection)map.get((Object)"bar"), Arrays.asList("foo, bar", "baz"));
        Assert.assertEquals((String)map.getFirstValue("baz"), (String)"foo");
        Assert.assertEquals((String)map.getJoinedValue("baz", ", "), (String)"foo, bar");
        Assert.assertEquals((Collection)map.get((Object)"baz"), Arrays.asList("foo", "bar"));
    }
}

