/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.BodyDeferringAsyncHandler;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BodyDeferringAsyncHandlerTest
extends AbstractBasicTest {
    protected static final int HALF_GIG = 100000;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
        out.close();
        in.close();
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SlowAndBigHandler();
    }

    public AsyncHttpClientConfig getAsyncHttpClientConfig() {
        return new AsyncHttpClientConfig.Builder().setMaxRequestRetry(0).setRequestTimeout(10000).build();
    }

    @Test(groups={"standalone", "default_provider"})
    public void deferredSimple() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(this.getAsyncHttpClientConfig());){
            AsyncHttpClient.BoundRequestBuilder r = client.prepareGet("http://127.0.0.1:" + this.port1 + "/deferredSimple");
            CountingOutputStream cos = new CountingOutputStream();
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)cos);
            ListenableFuture f = r.execute((AsyncHandler)bdah);
            Response resp = bdah.getResponse();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((boolean)true, (boolean)resp.getHeader("content-length").equals(String.valueOf(100000)));
            Assert.assertEquals((boolean)true, (100000 >= cos.getByteCount() ? 1 : 0) != 0);
            f.get();
            Assert.assertEquals((boolean)true, (100000 == cos.getByteCount() ? 1 : 0) != 0);
        }
    }

    @Test(groups={"standalone", "default_provider"}, enabled=false)
    public void deferredSimpleWithFailure() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(this.getAsyncHttpClientConfig());){
            AsyncHttpClient.BoundRequestBuilder r = client.prepareGet("http://127.0.0.1:" + this.port1 + "/deferredSimpleWithFailure").addHeader("X-FAIL-TRANSFER", Boolean.TRUE.toString());
            CountingOutputStream cos = new CountingOutputStream();
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)cos);
            ListenableFuture f = r.execute((AsyncHandler)bdah);
            Response resp = bdah.getResponse();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((boolean)true, (boolean)resp.getHeader("content-length").equals(String.valueOf(100000)));
            Assert.assertEquals((boolean)true, (100000 >= cos.getByteCount() ? 1 : 0) != 0);
            try {
                f.get();
                Assert.fail((String)"get() should fail with IOException!");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((boolean)false, (100000 == cos.getByteCount() ? 1 : 0) != 0);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void deferredInputStreamTrick() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(this.getAsyncHttpClientConfig());){
            AsyncHttpClient.BoundRequestBuilder r = client.prepareGet("http://127.0.0.1:" + this.port1 + "/deferredInputStreamTrick");
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream(pos);
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)pos);
            ListenableFuture f = r.execute((AsyncHandler)bdah);
            BodyDeferringAsyncHandler.BodyDeferringInputStream is = new BodyDeferringAsyncHandler.BodyDeferringInputStream((Future)f, bdah, (InputStream)pis);
            Response resp = is.getAsapResponse();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((boolean)true, (boolean)resp.getHeader("content-length").equals(String.valueOf(100000)));
            CountingOutputStream cos = new CountingOutputStream();
            BodyDeferringAsyncHandlerTest.copy((InputStream)is, cos);
            Assert.assertEquals((boolean)true, (100000 == cos.getByteCount() ? 1 : 0) != 0);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void deferredInputStreamTrickWithFailure() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(this.getAsyncHttpClientConfig());){
            AsyncHttpClient.BoundRequestBuilder r = client.prepareGet("http://127.0.0.1:" + this.port1 + "/deferredInputStreamTrickWithFailure").addHeader("X-FAIL-TRANSFER", Boolean.TRUE.toString());
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream(pos);
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)pos);
            ListenableFuture f = r.execute((AsyncHandler)bdah);
            BodyDeferringAsyncHandler.BodyDeferringInputStream is = new BodyDeferringAsyncHandler.BodyDeferringInputStream((Future)f, bdah, (InputStream)pis);
            Response resp = is.getAsapResponse();
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((boolean)true, (boolean)resp.getHeader("content-length").equals(String.valueOf(100000)));
            CountingOutputStream cos = new CountingOutputStream();
            try {
                BodyDeferringAsyncHandlerTest.copy((InputStream)is, cos);
                Assert.fail((String)"InputStream consumption should fail with IOException!");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testConnectionRefused() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(this.getAsyncHttpClientConfig());){
            int newPortWithoutAnyoneListening = this.findFreePort();
            AsyncHttpClient.BoundRequestBuilder r = client.prepareGet("http://127.0.0.1:" + newPortWithoutAnyoneListening + "/testConnectionRefused");
            CountingOutputStream cos = new CountingOutputStream();
            BodyDeferringAsyncHandler bdah = new BodyDeferringAsyncHandler((OutputStream)cos);
            r.execute((AsyncHandler)bdah);
            try {
                bdah.getResponse();
                Assert.fail((String)"IOException should be thrown here!");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class CountingOutputStream
    extends OutputStream {
        private int byteCount = 0;

        @Override
        public void write(int b) throws IOException {
            ++this.byteCount;
        }

        public int getByteCount() {
            return this.byteCount;
        }
    }

    public static class SlowAndBigHandler
    extends AbstractHandler {
        public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            httpResponse.setStatus(200);
            httpResponse.setContentLength(100000);
            httpResponse.setContentType("application/octet-stream");
            httpResponse.flushBuffer();
            boolean wantFailure = httpRequest.getHeader("X-FAIL-TRANSFER") != null;
            boolean wantSlow = httpRequest.getHeader("X-SLOW") != null;
            ServletOutputStream os = httpResponse.getOutputStream();
            for (int i = 0; i < 100000; ++i) {
                os.write(i % 255);
                if (wantSlow) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!wantFailure || i <= 50000) continue;
                httpResponse.sendError(500);
                break;
            }
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

