/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.async.BasicHttpsTest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class BasicHttpProxyToHttpsTest
extends AbstractBasicTest {
    private Server server2;

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.server2.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @AfterMethod(alwaysRun=true)
    public void tearDownProps() throws Exception {
        System.clearProperty("javax.net.ssl.keyStore");
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        this.server2 = new Server();
        this.port1 = this.findFreePort();
        this.port2 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        this.server.setHandler((Handler)this.configureHandler());
        this.server.start();
        HttpConfiguration https_config = new HttpConfiguration();
        https_config.setSecureScheme("https");
        https_config.setSecurePort(this.port2);
        https_config.setOutputBufferSize(32768);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(2000L);
        src.setStsIncludeSubDomains(true);
        https_config.addCustomizer((HttpConfiguration.Customizer)src);
        SslContextFactory sslContextFactory = new SslContextFactory();
        ClassLoader cl = this.getClass().getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        String trustStoreFile = new File(cacertsUrl.toURI()).getAbsolutePath();
        sslContextFactory.setTrustStorePath(trustStoreFile);
        sslContextFactory.setTrustStorePassword("changeit");
        sslContextFactory.setTrustStoreType("JKS");
        this.log.info("SSL certs path: {}", (Object)trustStoreFile);
        URL keystoreUrl = cl.getResource("ssltest-keystore.jks");
        String keyStoreFile = new File(keystoreUrl.toURI()).getAbsolutePath();
        sslContextFactory.setKeyStorePath(keyStoreFile);
        sslContextFactory.setKeyStorePassword("changeit");
        sslContextFactory.setKeyStoreType("JKS");
        this.log.info("SSL keystore path: {}", (Object)keyStoreFile);
        ServerConnector connector = new ServerConnector(this.server2, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        connector.setHost("127.0.0.1");
        connector.setPort(this.port2);
        this.server2.addConnector((Connector)connector);
        this.server2.setHandler((Handler)new AuthenticateHandler((Handler)new AbstractBasicTest.EchoHandler()));
        this.server2.start();
        this.log.info("Local Proxy Server (" + this.port1 + "), HTTPS Server (" + this.port2 + ") started successfully");
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ProxyConnectHTTPHandler((Handler)new AbstractBasicTest.EchoHandler());
    }

    @Test
    public void httpProxyToHttpsUsePreemptiveTargetTest() throws IOException, InterruptedException, ExecutionException, NoSuchAlgorithmException {
        this.doTest(true);
    }

    @Test
    public void httpProxyToHttpsTargetTest() throws IOException, InterruptedException, ExecutionException, NoSuchAlgorithmException {
        this.doTest(false);
    }

    private void doTest(boolean usePreemptiveAuth) throws UnknownHostException, InterruptedException, ExecutionException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setSSLContext(BasicHttpsTest.createSSLContext(new AtomicBoolean(true))).build());){
            Request request = ((RequestBuilder)new RequestBuilder("GET").setProxyServer(this.basicProxy()).setUrl(this.getTargetUrl2()).setRealm(new Realm.RealmBuilder().setPrincipal("user").setPassword("passwd").setScheme(Realm.AuthScheme.BASIC).setUsePreemptiveAuth(usePreemptiveAuth).build())).build();
            ListenableFuture responseFuture = client.executeRequest(request);
            Response response = (Response)responseFuture.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)("127.0.0.1:" + this.port2), (String)response.getHeader("x-host"));
        }
    }

    private ProxyServer basicProxy() throws UnknownHostException {
        ProxyServer proxyServer = new ProxyServer("127.0.0.1", this.port1, "johndoe", "pass");
        proxyServer.setScheme(Realm.AuthScheme.BASIC);
        return proxyServer;
    }

    private static class AuthenticateHandler
    extends HandlerWrapper {
        private Handler target;

        public AuthenticateHandler(Handler target) {
            this.target = target;
        }

        public void handle(String pathInContext, org.eclipse.jetty.server.Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            String authorization = httpRequest.getHeader("Authorization");
            if (authorization != null && authorization.equals("Basic dXNlcjpwYXNzd2Q=")) {
                httpResponse.addHeader("target", request.getHttpURI().getPath());
                this.target.handle(pathInContext, request, httpRequest, httpResponse);
            } else {
                httpResponse.setStatus(401);
                httpResponse.setHeader("www-authenticate", "Basic realm=\"Fake Realm\"");
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
                request.setHandled(true);
            }
        }
    }

    private static class ProxyConnectHTTPHandler
    extends ConnectHandler {
        public ProxyConnectHTTPHandler(Handler handler) {
            super(handler);
        }

        protected boolean handleAuthentication(HttpServletRequest request, HttpServletResponse response, String address) {
            return true;
        }

        protected void handleConnect(org.eclipse.jetty.server.Request baseRequest, HttpServletRequest request, HttpServletResponse response, String serverAddress) {
            try {
                if (!this.doHandleAuthentication(baseRequest, response)) {
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (ServletException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            super.handleConnect(baseRequest, request, response, serverAddress);
        }

        public boolean doHandleAuthentication(org.eclipse.jetty.server.Request request, HttpServletResponse httpResponse) throws IOException, ServletException {
            boolean result = false;
            if ("CONNECT".equals(request.getMethod())) {
                String authorization = request.getHeader("Proxy-Authorization");
                if (authorization == null) {
                    httpResponse.setStatus(407);
                    httpResponse.setHeader("Proxy-Authenticate", "Basic realm=\"Fake Realm\"");
                    result = false;
                    httpResponse.getOutputStream().flush();
                    httpResponse.getOutputStream().close();
                } else if (authorization.equals("Basic am9obmRvZTpwYXNz")) {
                    httpResponse.setStatus(200);
                    result = true;
                } else {
                    httpResponse.setStatus(401);
                    httpResponse.getOutputStream().flush();
                    httpResponse.getOutputStream().close();
                    result = false;
                }
                request.setHandled(true);
            }
            return result;
        }
    }
}

