/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Realm;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AuthTimeoutTest
extends AbstractBasicTest {
    private static final String user = "user";
    private static final String admin = "admin";

    public void setUpServer(String auth) throws Exception {
        this.server = new Server();
        Logger root = Logger.getRootLogger();
        root.setLevel(Level.DEBUG);
        root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
        this.port1 = this.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        HashLoginService loginService = new HashLoginService("MyRealm", "src/test/resources/realm.properties");
        this.server.addBean((Object)loginService);
        Constraint constraint = new Constraint();
        constraint.setName(auth);
        constraint.setRoles(new String[]{user, admin});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        HashSet<String> knownRoles = new HashSet<String>();
        knownRoles.add(user);
        knownRoles.add(admin);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        ArrayList<ConstraintMapping> cm = new ArrayList<ConstraintMapping>();
        cm.add(mapping);
        security.setConstraintMappings(cm, knownRoles);
        security.setAuthenticator((Authenticator)new BasicAuthenticator());
        security.setLoginService((LoginService)loginService);
        security.setHandler((Handler)this.configureHandler());
        this.server.setHandler((Handler)security);
        this.server.start();
        this.log.info("Local HTTP server started successfully");
    }

    @Test(groups={"standalone", "default_provider"}, enabled=false)
    public void basicAuthTimeoutTest() throws Exception {
        this.setUpServer("BASIC");
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setPooledConnectionIdleTimeout(2000).setConnectTimeout(20000).setRequestTimeout(2000).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Future<Response> f = this.execute(client, false);
            try {
                f.get();
                Assert.fail((String)"expected timeout");
            }
            catch (Exception e) {
                this.inspectException(e);
            }
        }
    }

    @Test(groups={"standalone", "default_provider"}, enabled=false)
    public void basicPreemptiveAuthTimeoutTest() throws Exception {
        this.setUpServer("BASIC");
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setPooledConnectionIdleTimeout(2000).setConnectTimeout(20000).setRequestTimeout(2000).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Future<Response> f = this.execute(client, true);
            try {
                f.get();
                Assert.fail((String)"expected timeout");
            }
            catch (Exception e) {
                this.inspectException(e);
            }
        }
    }

    @Test(groups={"standalone", "default_provider"}, enabled=false)
    public void digestAuthTimeoutTest() throws Exception {
        this.setUpServer("DIGEST");
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setPooledConnectionIdleTimeout(2000).setConnectTimeout(20000).setRequestTimeout(2000).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Future<Response> f = this.execute(client, false);
            try {
                f.get();
                Assert.fail((String)"expected timeout");
            }
            catch (Exception e) {
                this.inspectException(e);
            }
        }
    }

    @Test(groups={"standalone", "default_provider"}, enabled=false)
    public void digestPreemptiveAuthTimeoutTest() throws Exception {
        this.setUpServer("DIGEST");
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setPooledConnectionIdleTimeout(2000).setConnectTimeout(20000).setRequestTimeout(2000).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Future<Response> f = this.execute(client, true);
            f.get();
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone", "default_provider"}, enabled=false)
    public void basicFutureAuthTimeoutTest() throws Exception {
        this.setUpServer("BASIC");
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setPooledConnectionIdleTimeout(2000).setConnectTimeout(20000).setRequestTimeout(2000).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Future<Response> f = this.execute(client, false);
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone", "default_provider"}, enabled=false)
    public void basicFuturePreemptiveAuthTimeoutTest() throws Exception {
        this.setUpServer("BASIC");
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setPooledConnectionIdleTimeout(2000).setConnectTimeout(20000).setRequestTimeout(2000).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Future<Response> f = this.execute(client, true);
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone", "default_provider"}, enabled=false)
    public void digestFutureAuthTimeoutTest() throws Exception {
        this.setUpServer("DIGEST");
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setPooledConnectionIdleTimeout(2000).setConnectTimeout(20000).setRequestTimeout(2000).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Future<Response> f = this.execute(client, false);
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    @Test(groups={"standalone", "default_provider"}, enabled=false)
    public void digestFuturePreemptiveAuthTimeoutTest() throws Exception {
        this.setUpServer("DIGEST");
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setPooledConnectionIdleTimeout(2000).setConnectTimeout(20000).setRequestTimeout(2000).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            Future<Response> f = this.execute(client, true);
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"expected timeout");
        }
        catch (Exception e) {
            this.inspectException(e);
        }
    }

    protected void inspectException(Throwable t) {
        Assert.assertNotNull((Object)t.getCause());
        Assert.assertEquals(t.getCause().getClass(), IOException.class);
        if (!t.getCause().getMessage().startsWith("Remotely Closed")) {
            Assert.fail();
        }
    }

    protected Future<Response> execute(AsyncHttpClient client, boolean preemptive) throws IOException {
        AsyncHttpClient.BoundRequestBuilder r = ((AsyncHttpClient.BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRealm(this.realm(preemptive))).setHeader("X-Content", "Test");
        ListenableFuture f = r.execute();
        return f;
    }

    private Realm realm(boolean preemptive) {
        return new Realm.RealmBuilder().setPrincipal(user).setPassword(admin).setUsePreemptiveAuth(preemptive).build();
    }

    @Override
    protected String getTargetUrl() {
        return "http://127.0.0.1:" + this.port1 + "/";
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SimpleHandler();
    }

    private class SimpleHandler
    extends AbstractHandler {
        private SimpleHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ServletOutputStream out = response.getOutputStream();
            if (request.getHeader("X-Content") != null) {
                String content = request.getHeader("X-Content");
                response.setHeader("Content-Length", String.valueOf(content.getBytes("UTF-8").length));
                out.write(content.substring(1).getBytes("UTF-8"));
                out.flush();
                out.close();
                return;
            }
            response.setStatus(200);
            out.flush();
            out.close();
        }
    }
}

