/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.multipart;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.FilePart;
import com.ning.http.client.multipart.MultipartBody;
import com.ning.http.client.multipart.MultipartUtils;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.StringPart;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MultipartBodyTest {
    private static final List<Part> PARTS = new ArrayList<Part>();
    private static long MAX_MULTIPART_CONTENT_LENGTH_ESTIMATE;

    private static File getTestfile() throws URISyntaxException {
        ClassLoader cl = MultipartBodyTest.class.getClassLoader();
        URL url = cl.getResource("textfile.txt");
        Assert.assertNotNull((Object)url);
        return new File(url.toURI());
    }

    private static MultipartBody buildMultipart() {
        return MultipartUtils.newMultipartBody(PARTS, (FluentCaseInsensitiveStringsMap)new FluentCaseInsensitiveStringsMap());
    }

    @Test
    public void transferWithCopy() throws Exception {
        int bufferLength = 1;
        while ((long)bufferLength < MAX_MULTIPART_CONTENT_LENGTH_ESTIMATE + 1L) {
            try (MultipartBody multipartBody = MultipartBodyTest.buildMultipart();){
                long tranferred = MultipartBodyTest.transferWithCopy(multipartBody, bufferLength);
                Assert.assertEquals((long)tranferred, (long)multipartBody.getContentLength());
            }
            ++bufferLength;
        }
    }

    @Test
    public void transferZeroCopy() throws Exception {
        int bufferLength = 1;
        while ((long)bufferLength < MAX_MULTIPART_CONTENT_LENGTH_ESTIMATE + 1L) {
            try (MultipartBody multipartBody = MultipartBodyTest.buildMultipart();){
                long tranferred = MultipartBodyTest.transferZeroCopy(multipartBody, bufferLength);
                Assert.assertEquals((long)tranferred, (long)multipartBody.getContentLength());
            }
            ++bufferLength;
        }
    }

    private static long transferWithCopy(MultipartBody multipartBody, int bufferSize) throws IOException {
        long readBytes;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        long totalBytes = 0L;
        while ((readBytes = multipartBody.read(buffer)) >= 0L) {
            buffer.clear();
            totalBytes += readBytes;
        }
        return totalBytes;
    }

    private static long transferZeroCopy(MultipartBody multipartBody, int bufferSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        final AtomicLong transferred = new AtomicLong();
        WritableByteChannel mockChannel = new WritableByteChannel(){

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                int written = src.remaining();
                transferred.set(transferred.get() + (long)written);
                src.position(src.limit());
                return written;
            }
        };
        while (transferred.get() < multipartBody.getContentLength()) {
            multipartBody.transferTo(0L, mockChannel);
            buffer.clear();
        }
        return transferred.get();
    }

    static {
        try {
            PARTS.add((Part)new FilePart("filePart", MultipartBodyTest.getTestfile()));
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        PARTS.add((Part)new ByteArrayPart("baPart", "testMultiPart".getBytes(StandardCharsets.UTF_8), "application/test", StandardCharsets.UTF_8, "fileName"));
        PARTS.add((Part)new StringPart("stringPart", "testString"));
        try (MultipartBody dummyBody = MultipartBodyTest.buildMultipart();){
            MAX_MULTIPART_CONTENT_LENGTH_ESTIMATE = dummyBody.getContentLength() + 100L;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

