/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class ParamEncodingTest
extends AbstractBasicTest {
    @Test(groups={"standalone", "default_provider"})
    public void testParameters() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        String value = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKQLMNOPQRSTUVWXYZ1234567809`~!@#$%^&*()_+-=,.<>/?;:'\"[]{}\\| ";
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture f = client.preparePost("http://127.0.0.1:" + this.port1).addFormParam("test", value).execute();
            Response resp = (Response)f.get(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("X-Param"), (String)value.trim());
        }
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ParamEncoding();
    }

    private class ParamEncoding
    extends AbstractHandler {
        private ParamEncoding() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("POST".equalsIgnoreCase(request.getMethod())) {
                String p = request.getParameter("test");
                if (MiscUtils.isNonEmpty((String)p)) {
                    response.setStatus(200);
                    response.addHeader("X-Param", p);
                } else {
                    response.sendError(406);
                }
            } else {
                response.sendError(403);
            }
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
    }
}

