/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.Deflater;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.compression.SpdyDeflaterOutputStream;
import org.glassfish.grizzly.spdy.compression.Utils;
import org.glassfish.grizzly.utils.Charsets;

public final class CompressedHeadersBuilder {
    private final Map<String, String> headers = new HashMap<String, String>();

    public static Deflater createSpdyDeflater() {
        Deflater deflater = new Deflater();
        Utils.setSpdyCompressionDictionary(deflater);
        return deflater;
    }

    private CompressedHeadersBuilder() {
    }

    public static CompressedHeadersBuilder newInstance() {
        return new CompressedHeadersBuilder();
    }

    public final CompressedHeadersBuilder contentLength(long contentLength) {
        return this.header(Header.ContentLength, String.valueOf(contentLength));
    }

    public final CompressedHeadersBuilder contentType(String contentType) {
        return this.header(Header.ContentType, String.valueOf(contentType));
    }

    public final CompressedHeadersBuilder method(Method method) {
        return this.method(method.getMethodString());
    }

    public final CompressedHeadersBuilder method(String method) {
        return this.header(":method", method);
    }

    public final CompressedHeadersBuilder path(String path) {
        return this.header(":path", path);
    }

    public final CompressedHeadersBuilder version(Protocol version) {
        return this.version(version.getProtocolString());
    }

    public final CompressedHeadersBuilder version(String version) {
        return this.header(":version", version);
    }

    public final CompressedHeadersBuilder host(String host) {
        return this.header(":host", host);
    }

    public final CompressedHeadersBuilder scheme(String scheme) {
        return this.header(":scheme", scheme);
    }

    public final CompressedHeadersBuilder status(int status) {
        return this.status(String.valueOf(status));
    }

    public final CompressedHeadersBuilder status(HttpStatus status) {
        StringBuilder sb = new StringBuilder();
        sb.append(status.getStatusCode()).append(' ').append(new String(status.getReasonPhraseBytes(), Constants.DEFAULT_HTTP_CHARSET));
        return this.status(sb.toString());
    }

    public final CompressedHeadersBuilder status(String status) {
        return this.header(":status", status);
    }

    public final CompressedHeadersBuilder header(String name, String value) {
        this.headers.put(name.toLowerCase(Locale.US), value);
        return this;
    }

    public final CompressedHeadersBuilder header(Header header, String value) {
        this.headers.put(header.toString().toLowerCase(Locale.US), value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer build(Deflater deflater) throws IOException {
        SpdyDeflaterOutputStream deflaterOutput = new SpdyDeflaterOutputStream(MemoryManager.DEFAULT_MEMORY_MANAGER, deflater);
        DataOutputStream dataOutput = new DataOutputStream(deflaterOutput);
        try {
            dataOutput.writeInt(this.headers.size());
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                byte[] name = entry.getKey().getBytes(Charsets.ASCII_CHARSET.name());
                byte[] value = entry.getValue().getBytes(Charsets.ASCII_CHARSET.name());
                dataOutput.writeInt(name.length);
                dataOutput.write(name);
                dataOutput.writeInt(value.length);
                dataOutput.write(value);
            }
            dataOutput.flush();
            deflaterOutput.closeStreamOnly();
            Buffer buffer = deflaterOutput.checkpoint();
            return buffer;
        }
        finally {
            try {
                dataOutput.close();
            }
            catch (IOException iOException) {}
        }
    }
}

