/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.documentation.types;

import java.util.Optional;
import java.util.StringJoiner;
import org.mule.extension.maven.documentation.NamePrettifier;
import org.mule.extension.maven.documentation.types.TypeFlattener;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;

class ObjectTypeUtils {
    ObjectTypeUtils() {
    }

    static Optional<String> getObjectTypeId(ObjectType objectType) {
        Optional id = MetadataTypeUtils.getTypeId((MetadataType)objectType);
        Optional<String> alias = objectType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue);
        if (id.filter(value -> value.startsWith("javax.") || value.startsWith("java.")).isPresent()) {
            return TypeUtils.isInfrastructure((MetadataType)objectType) && alias.isPresent() ? alias : Optional.empty();
        }
        return alias.isPresent() ? alias : id.map(v -> v.contains(".") ? v.substring(v.lastIndexOf(".") + 1) : v);
    }

    static String toAsciidoc(ObjectType type, TypeFlattener flattener) {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add("[cols=\".^50%,.^50%\", options=\"header\"]");
        stringJoiner.add("|======================");
        stringJoiner.add("| Field | Type ");
        type.getFields().forEach(field -> {
            String localPart = MetadataTypeUtils.getLocalPart((ObjectFieldType)field);
            stringJoiner.add(String.format("| %s a| %s", NamePrettifier.prettify(localPart), flattener.flat(field.getValue())));
        });
        stringJoiner.add("|======================");
        return stringJoiner.toString();
    }

    static boolean isMessage(ObjectType objectType) {
        Optional typeId = MetadataTypeUtils.getTypeId((MetadataType)objectType);
        return typeId.isPresent() && ((String)typeId.get()).equals(Message.class.getName());
    }
}

