/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.documentation;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.HasDisplayModel;

public class NamePrettifier {
    public static String prettify(NamedObject component) {
        return NamePrettifier.getDisplayName((HasDisplayModel)component).orElse(NamePrettifier.prettify(component.getName()));
    }

    public static String prettify(String name) {
        StringBuilder pretty = new StringBuilder();
        boolean shouldCapitalizeNext = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '-' || Character.isWhitespace(c)) {
                shouldCapitalizeNext = true;
                pretty.append(" ");
                continue;
            }
            if (NamePrettifier.shouldAddWhitespace(name, i, c) && !NamePrettifier.endsWithWhitespace(pretty)) {
                pretty.append(" ");
            }
            if (shouldCapitalizeNext) {
                pretty.append(Character.toUpperCase(c));
                shouldCapitalizeNext = false;
                continue;
            }
            pretty.append(c);
        }
        return pretty.toString().trim();
    }

    private static Optional<String> getDisplayName(HasDisplayModel model) {
        Optional displayModel = model.getDisplayModel();
        return displayModel.isPresent() && !StringUtils.isBlank((CharSequence)((DisplayModel)displayModel.get()).getDisplayName()) ? Optional.ofNullable(((DisplayModel)displayModel.get()).getDisplayName()) : Optional.empty();
    }

    private static boolean shouldAddWhitespace(String name, int i, char c) {
        return Character.isUpperCase(c) && (!NamePrettifier.previousIsUppercase(name, i) || NamePrettifier.previousIsUppercase(name, i) && NamePrettifier.nextIsLowercase(name, i));
    }

    private static boolean previousIsUppercase(String name, int i) {
        return i > 0 && Character.isUpperCase(name.charAt(i - 1));
    }

    private static boolean nextIsLowercase(String name, int i) {
        return i < name.length() - 1 && Character.isLowerCase(name.charAt(i + 1));
    }

    private static boolean endsWithWhitespace(StringBuilder builder) {
        return builder.length() > 0 && Character.isWhitespace(builder.charAt(builder.length() - 1));
    }
}

