/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.documentation;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.mule.extension.maven.documentation.NamePrettifier;
import org.mule.extension.maven.documentation.types.TypeFlattener;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;

public class DocumentationGenerator {
    private static final String TEMPLATE = "documentation/main-template.vm";
    private static final String CSS_FILE_NAME = "styles";
    private static final String CSS_EXTENSION = ".css";

    public String generateAsciidoc(ExtensionModel extension) {
        StringWriter writer = new StringWriter();
        VelocityEngine engine = this.getVelocityEngine();
        VelocityContext context = this.getVelocityContext(extension);
        engine.getTemplate(TEMPLATE).merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    public String generateHtml(String asciidoc) {
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        File css = this.getCssFile();
        Options options = OptionsBuilder.options().headerFooter(true).safe(SafeMode.UNSAFE).attributes(AttributesBuilder.attributes().stylesDir(css.getParent()).styleSheetName(css.getName()).get()).get();
        return asciidoctor.render(asciidoc, options);
    }

    private File getCssFile() {
        try {
            File css = File.createTempFile(CSS_FILE_NAME, CSS_EXTENSION);
            this.copyStreamToFile(this.getClass().getResourceAsStream("/documentation/styles.css"), css);
            return css;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while obtaining css file: " + e.getMessage(), e);
        }
    }

    private VelocityContext getVelocityContext(ExtensionModel extension) {
        VelocityContext context = new VelocityContext();
        DslSyntaxResolver dsl = DslSyntaxResolver.getDefault((ExtensionModel)extension, (ImportTypesStrategy)new SingleExtensionImportTypesStrategy());
        context.put("label", (Object)this.getLabel(extension));
        context.put("dsl", (Object)dsl);
        context.put("sources", this.getSourcesMap(extension));
        context.put("operations", this.getOperationsMap(extension));
        context.put("flattener", (Object)new TypeFlattener(extension));
        context.put("nameUtil", NamePrettifier.class);
        context.put("extension", (Object)extension);
        return context;
    }

    private String getLabel(ExtensionModel extension) {
        return extension.getConfigurationModels().isEmpty() ? "Module" : "Connector";
    }

    private Multimap<OperationModel, String> getOperationsMap(ExtensionModel extension) {
        LinkedListMultimap operations = LinkedListMultimap.create();
        extension.getConfigurationModels().forEach(arg_0 -> DocumentationGenerator.lambda$getOperationsMap$1((Multimap)operations, arg_0));
        return operations;
    }

    private Multimap<SourceModel, String> getSourcesMap(ExtensionModel extension) {
        LinkedListMultimap sources = LinkedListMultimap.create();
        extension.getConfigurationModels().forEach(arg_0 -> DocumentationGenerator.lambda$getSourcesMap$3((Multimap)sources, arg_0));
        return sources;
    }

    private VelocityEngine getVelocityEngine() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("runtime.log.logsystem.class", (Object)NullLogChute.class.getName());
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        return ve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStreamToFile(InputStream input, File destination) throws IOException {
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Destination file does not exist or cannot be written");
        }
        try {
            FileOutputStream output = new FileOutputStream(destination);
            try {
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private static /* synthetic */ void lambda$getSourcesMap$3(Multimap sources, ConfigurationModel config) {
        config.getSourceModels().forEach(source -> sources.put(source, (Object)config.getName()));
    }

    private static /* synthetic */ void lambda$getOperationsMap$1(Multimap operations, ConfigurationModel config) {
        config.getOperationModels().forEach(ope -> operations.put(ope, (Object)config.getName()));
    }
}

