/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.loader;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;

public class MulePluginJsonDescriberLoader {
    public static final String MULE_PLUGIN_JSON = "mule-plugin.json";
    public static final String META_INF = "META-INF";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MulePluginModel loadMulePluginDescriber(MavenProject project) throws MojoFailureException {
        Path path = Paths.get(project.getBuild().getOutputDirectory(), META_INF, MULE_PLUGIN_JSON);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new MojoFailureException(String.format("Could not obtain descriptor file from [%s]", path.toString()));
        }
        try (FileInputStream stream = new FileInputStream(path.toFile());){
            MulePluginModel mulePluginModel = (MulePluginModel)new MulePluginModelJsonSerializer().deserialize(IOUtils.toString((InputStream)stream));
            return mulePluginModel;
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Could not read resource under [%s]", path.toFile().getAbsolutePath()), (Throwable)e);
        }
    }
}

