/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.loader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;

public class MavenProjectExtensionModelLoader {
    private final Log log;

    public MavenProjectExtensionModelLoader(Log log) {
        this.log = log;
    }

    public ExtensionModel loadExtension(MavenProject project, MulePluginModel mulePluginDescriber) throws MojoFailureException, MojoExecutionException {
        MuleArtifactLoaderDescriptor loaderDescriptor = this.getExtensionLoaderDescriptor(mulePluginDescriber);
        ClassLoader pluginClassLoader = this.getInvokerClassLoader(project);
        this.log.info((CharSequence)String.format("Creating ExtensionModel for name:[%s], ID:[%s]", mulePluginDescriber.getName(), loaderDescriptor.getId()));
        ExtensionModelLoader extensionModelLoader = this.getExtensionModelLoader(loaderDescriptor.getId(), pluginClassLoader);
        return extensionModelLoader.loadExtensionModel(pluginClassLoader, loaderDescriptor.getAttributes());
    }

    private MuleArtifactLoaderDescriptor getExtensionLoaderDescriptor(MulePluginModel jsonDescriber) throws MojoExecutionException, MojoFailureException {
        return (MuleArtifactLoaderDescriptor)jsonDescriber.getExtensionModelLoaderDescriptor().orElseThrow(() -> new MojoExecutionException(String.format("The plugin [%s] does not have a ExtensionLoader descriptor, nothing to generate so far.", jsonDescriber.getName())));
    }

    private ClassLoader getInvokerClassLoader(MavenProject project) throws MojoFailureException {
        List invokerClasspathElements;
        try {
            invokerClasspathElements = project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException("There was an issue trying to consume the classpath for the current project.", (Throwable)e);
        }
        invokerClasspathElements.add(project.getBuild().getOutputDirectory());
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)String.format("Classpath to process: [%s]", String.join((CharSequence)",", invokerClasspathElements)));
        }
        URL[] urls = new URL[invokerClasspathElements.size()];
        for (int i = 0; i < invokerClasspathElements.size(); ++i) {
            String invokerClasspathElement = (String)invokerClasspathElements.get(i);
            try {
                urls[i] = new File(invokerClasspathElement).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new MojoFailureException(String.format("There was an issue trying to convert the element [%s] to an URL. Full classpath: [%s]", invokerClasspathElement, String.join((CharSequence)",", invokerClasspathElements)));
            }
        }
        return new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    private ExtensionModelLoader getExtensionModelLoader(String id, ClassLoader pluginClassLoader) throws MojoFailureException {
        ArrayList<String> foundIds = new ArrayList<String>();
        ServiceLoader<ExtensionModelLoader> extensionModelLoaders = ServiceLoader.load(ExtensionModelLoader.class, pluginClassLoader);
        for (ExtensionModelLoader extensionModelLoader : extensionModelLoaders) {
            foundIds.add(String.format("Class:[%s]; ID:[%s].", extensionModelLoader.getClass().getName(), extensionModelLoader.getId()));
            if (!id.equals(extensionModelLoader.getId())) continue;
            return extensionModelLoader;
        }
        throw new MojoFailureException(String.format("Failure while looking for an implementation class of [%s] class through SPI for the ID [%s]. Found resources: \n%s", ExtensionModelLoader.class.getName(), id, String.join((CharSequence)", \n", foundIds)));
    }
}

