/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.mule.extension.maven.loader.MavenProjectExtensionModelLoader;
import org.mule.extension.maven.loader.MulePluginJsonDescriberLoader;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;

@Mojo(name="extension-model", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class ExtensionModelMojo
extends AbstractMuleMojo {
    private static final String TEMPORAL_EXTENSION_MODEL_JSON = "temporal_extension_model.json";
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MulePluginModel mulePluginDescriber = MulePluginJsonDescriberLoader.loadMulePluginDescriber(this.project);
        MavenProjectExtensionModelLoader extensionModelLoader = new MavenProjectExtensionModelLoader(this.getLog());
        ExtensionModel extensionModel = extensionModelLoader.loadExtension(this.project, mulePluginDescriber);
        String serializedExtensionModel = new ExtensionModelJsonSerializer(true).serialize(extensionModel);
        File generatedExtensionModelFile = new File(this.outputDirectory, TEMPORAL_EXTENSION_MODEL_JSON);
        try (PrintWriter out = new PrintWriter(generatedExtensionModelFile);){
            out.println(serializedExtensionModel);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException(String.format("Failure while saving the serialized ExtensionModel to the file [%s]", generatedExtensionModelFile.getAbsolutePath()));
        }
        this.projectHelper.attachArtifact(this.project, "json", "extension-model-" + mulePluginDescriber.getMinMuleVersion(), generatedExtensionModelFile);
    }
}

