/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.mule.extension.maven.generator.GenerationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StudioSiteXmlGenerator {
    private static final String CATEGORY_XML = "category.xml";
    private final MavenProject project;
    private final GenerationContext context;

    public StudioSiteXmlGenerator(GenerationContext context) {
        this.project = context.getMavenProject();
        this.context = context;
    }

    public void generate() throws MojoFailureException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element site = document.createElement("site");
            document.appendChild(site);
            Element feature = document.createElement("feature");
            feature.setAttribute("id", this.context.getFeatureId());
            Element categoryElement = document.createElement("category");
            categoryElement.setAttribute("name", this.project.getGroupId());
            feature.appendChild(categoryElement);
            Element categoryDef = document.createElement("category-def");
            categoryDef.setAttribute("name", this.project.getGroupId());
            categoryDef.setAttribute("label", StringUtils.capitalize((String)StringUtils.lowerCase((String)this.context.getExtensionCategory().name())));
            site.appendChild(feature);
            site.appendChild(categoryDef);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(this.context.getOutputDirectory(), CATEGORY_XML));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new MojoFailureException("Error happened generating 'category.xml' file", (Throwable)e);
        }
    }
}

