/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.generator;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.mule.extension.maven.generator.GenerationContext;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;

public class StudioManifestGenerator {
    private final ExtensionManifest manifest;
    private final ExtensionModel extensionModel;
    private final GenerationContext context;

    public StudioManifestGenerator(GenerationContext context) {
        this.manifest = context.getExtensionManifest();
        this.extensionModel = context.getExtensionModel();
        this.context = context;
    }

    public void generate() throws MojoFailureException {
        PrintStream printStream = null;
        try {
            File manifestFile = new File(this.context.getPluginOutputDirectory(), "META-INF/MANIFEST.MF");
            Files.createParentDirs((File)manifestFile);
            printStream = new PrintStream(manifestFile);
            printStream.append(this.getManifestContents());
            printStream.flush();
        }
        catch (IOException e) {
            try {
                throw new MojoFailureException("Error occurred generating 'MANIFEST.MF' file", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(printStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)printStream);
    }

    private String getManifestContents() {
        return "Manifest-Version: 1.0\nBundle-ManifestVersion: 2\nBundle-Name: " + this.manifest.getName() + "\nBundle-SymbolicName: " + this.context.getSymbolicName() + ";singleton:=true\nBundle-Version: " + this.context.getBundleVersion() + "\nBundle-Vendor: " + this.extensionModel.getVendor() + "\nRequire-Bundle: org.eclipse.ui,\n org.eclipse.core.runtime,\n org.mule.tooling.core;bundle-version=\"1.0.0\"\nBundle-RequiredExecutionEnvironment: JavaSE-1.8\nBundle-ActivationPolicy: lazy\nEclipse-BundleShape: dir\n";
    }
}

